/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import net.pageseeder.aws.AwsService;
import net.pageseeder.aws.AwsSignatureVersion4;
import net.pageseeder.aws.Header;
import net.pageseeder.aws.LiteAwsConfig;
import net.pageseeder.aws.LiteAwsRequest;
import net.pageseeder.aws.LiteAwsResponse;
import net.pageseeder.aws.Parameters;
import net.pageseeder.aws.Payload;

public final class LiteAwsClient {
    private final LiteAwsConfig config;

    public LiteAwsClient(LiteAwsConfig config) {
        this.config = config;
    }

    public LiteAwsConfig config() {
        return this.config;
    }

    public LiteAwsResponse get(AwsService service, String path) throws IOException {
        LiteAwsRequest req = LiteAwsRequest.newGetRequest(service, path, Parameters.empty());
        return this.fetch(req);
    }

    public LiteAwsResponse get(AwsService service, String path, Parameters parameters) throws IOException {
        LiteAwsRequest req = LiteAwsRequest.newGetRequest(service, path, parameters);
        return this.fetch(req);
    }

    public LiteAwsResponse post(AwsService service, String path, Payload payload) throws IOException {
        LiteAwsRequest req = LiteAwsRequest.newPostRequest(service, path, payload);
        return this.fetch(req);
    }

    public LiteAwsResponse fetch(LiteAwsRequest req) throws IOException {
        LiteAwsRequest signed = req;
        if (!req.hasAuthorization()) {
            AwsSignatureVersion4 signer = new AwsSignatureVersion4(this.config);
            signed = signer.authorize(req);
        }
        return this.fetchAuthorized(signed);
    }

    private LiteAwsResponse fetchAuthorized(LiteAwsRequest req) throws IOException {
        String method = req.method();
        String endpoint = req.toUrl();
        URL url = new URL(endpoint);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        for (Header h : req.headers()) {
            if (h.name().equalsIgnoreCase("Host")) continue;
            connection.setRequestProperty(h.name(), h.value());
        }
        if (req.hasPayload()) {
            connection.setDoOutput(true);
            connection.getOutputStream().write(req.payload().bytes());
            connection.getOutputStream().flush();
            connection.getOutputStream().close();
        }
        return LiteAwsResponse.fromConnection(connection);
    }
}

