/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.pageseeder.aws.AmzDate;
import net.pageseeder.aws.AwsService;
import net.pageseeder.aws.Header;
import net.pageseeder.aws.LiteAwsConfig;
import net.pageseeder.aws.LiteAwsRequest;
import net.pageseeder.aws.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AwsSignatureVersion4 {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwsSignatureVersion4.class);
    public static final String ALGORITHM = "AWS4-HMAC-SHA256";
    private final LiteAwsConfig config;

    public AwsSignatureVersion4(LiteAwsConfig config) {
        this.config = config;
    }

    public LiteAwsConfig config() {
        return this.config;
    }

    public LiteAwsRequest authorize(LiteAwsRequest req) {
        String authorization = this.getAuthorization(req);
        return req.withHeader(new Header("Authorization", authorization, false));
    }

    public String getAuthorization(LiteAwsRequest req) {
        AmzDate amzDate = req.amzDate();
        String dateStamp = amzDate.dateOnly();
        AwsService service = req.service();
        String signedHeaders = String.join((CharSequence)";", req.headers().signed().sortByName().lcNames());
        String canonicalRequest = this.buildCanonicalRequest(req, signedHeaders);
        LOGGER.debug("Canonical Request: {}", (Object)canonicalRequest);
        String credentialScope = dateStamp + "/" + this.config.region() + "/" + service.scope() + "/aws4_request";
        String stringToSign = this.buildStringToSign(amzDate, credentialScope, canonicalRequest);
        LOGGER.debug("String-to-Sign: {}", (Object)canonicalRequest);
        byte[] signingKey = AwsSignatureVersion4.getSignatureKey(this.config.secret(), dateStamp, this.config.region(), service.scope());
        String signature = Utils.toHex(AwsSignatureVersion4.hmacSHA256(stringToSign, signingKey));
        return "AWS4-HMAC-SHA256 Credential=" + this.config.key() + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
    }

    private String buildCanonicalRequest(LiteAwsRequest req, String signedHeaders) {
        String method = req.method();
        String canonicalUri = AwsSignatureVersion4.toCanonicalUri(req);
        String canonicalQueryString = AwsSignatureVersion4.toCanonicalQueryString(req);
        String canonicalHeaders = AwsSignatureVersion4.toCanonicalHeaders(req);
        String payloadHash = Utils.hash(req.payload().content());
        return method + "\n" + canonicalUri + "\n" + canonicalQueryString + "\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + payloadHash;
    }

    private static String toCanonicalUri(LiteAwsRequest req) {
        return Utils.uriEncode(req.path(), true);
    }

    private static String toCanonicalQueryString(LiteAwsRequest req) {
        return req.parameters().canonicalize().toQueryString();
    }

    private static String toCanonicalHeaders(LiteAwsRequest req) {
        return req.headers().signed().sortByName().toCanonical();
    }

    private String buildStringToSign(AmzDate timestamp, String credentialScope, String canonicalRequest) {
        String hashedCanonicalRequest = Utils.hash(canonicalRequest);
        return "AWS4-HMAC-SHA256\n" + String.valueOf(timestamp) + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
    }

    private static byte[] hmacSHA256(String data, byte[] key) {
        String algorithm = "HmacSHA256";
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("HmacSHA256 not supported", ex);
        }
        catch (InvalidKeyException ex) {
            throw new IllegalArgumentException("Invalid key used for HmacSHA256", ex);
        }
    }

    private static byte[] getSignatureKey(String secretKey, String dateStamp, String region, String service) {
        byte[] kDate = AwsSignatureVersion4.hmacSHA256(dateStamp, ("AWS4" + secretKey).getBytes(StandardCharsets.UTF_8));
        byte[] kRegion = AwsSignatureVersion4.hmacSHA256(region, kDate);
        byte[] kService = AwsSignatureVersion4.hmacSHA256(service, kRegion);
        return AwsSignatureVersion4.hmacSHA256("aws4_request", kService);
    }
}

