/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;

public final class AmzDate {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
    private static final DateTimeFormatter DATE_ONLY = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final LocalDateTime dateTime;

    private AmzDate(LocalDateTime dateTime) {
        this.dateTime = Objects.requireNonNull(dateTime);
    }

    public AmzDate() {
        this(LocalDateTime.now(ZoneOffset.UTC));
    }

    public static AmzDate of(LocalDateTime dateTime) {
        return new AmzDate(dateTime);
    }

    public static AmzDate of(OffsetDateTime dateTime) {
        return new AmzDate(dateTime.withOffsetSameInstant(ZoneOffset.UTC).toLocalDateTime());
    }

    public static AmzDate of(ZonedDateTime dateTime) {
        return new AmzDate(dateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime());
    }

    public static AmzDate of(String dateTime) throws IllegalArgumentException {
        try {
            return new AmzDate(LocalDateTime.parse(dateTime, FORMATTER));
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException("Invalid date time format", ex);
        }
    }

    public String dateOnly() {
        return this.dateTime.format(DATE_ONLY);
    }

    public String toString() {
        return this.dateTime.format(FORMATTER);
    }
}

