/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.oauth;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;

public enum Scope {
    OPENID,
    PROFILE,
    EMAIL,
    GUEST,
    REVIEWER,
    CONTRIBUTOR,
    MANAGER,
    APPROVER,
    PROJECT_CONTRIBUTOR,
    PROJECT_MANAGER,
    SERVER_GUEST,
    SERVER_REVIEWER,
    SERVER_CONTRIBUTOR,
    SERVER_MANAGER,
    SERVER_APPROVER,
    SERVER_PROJECT_CONTRIBUTOR,
    SERVER_PROJECT_MANAGER,
    PROJECT_CREATOR,
    DEVELOPER,
    ACCOUNT_MANAGER,
    OAUTH_MANAGER,
    WEBHOOK_MANAGER,
    ADMIN,
    ALL,
    UNKNOWN;

    private static final List<Scope> groupOrder;
    private static final List<Scope> projectOrder;
    private static final List<Scope> serverGroupOrder;
    private static final List<Scope> serverProjectOrder;

    public static final Set<Scope> filterScopes(Collection<Scope> scopes, Collection<Scope> filter) {
        HashSet<Scope> filtered = new HashSet<Scope>();
        for (Scope s : scopes) {
            if (filter.contains((Object)s)) {
                filtered.add(s);
                continue;
            }
            for (Scope fs : filter) {
                if (!s.isLowerThan(fs)) continue;
                filtered.add(s);
            }
        }
        return filtered;
    }

    public static Set<Scope> fromDelimitedString(@Nullable String values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(values.split("\\s+")).filter(s -> !s.isEmpty()).map(Scope::fromString).collect(Collectors.toSet());
    }

    public static Scope fromString(String value) throws IllegalArgumentException {
        value = value.replace('-', '_');
        for (Scope n : Scope.values()) {
            if (!n.name().toLowerCase().equals(value)) continue;
            return n;
        }
        return UNKNOWN;
    }

    public static String join(String delimiter, Set<Scope> scopes) {
        return scopes.stream().map(Enum::toString).collect(Collectors.joining(delimiter));
    }

    public boolean isLowerThan(Scope scope) {
        if (groupOrder.contains((Object)scope)) {
            return this.isBefore(scope, groupOrder);
        }
        if (projectOrder.contains((Object)scope)) {
            return this.isBefore(scope, projectOrder);
        }
        if (serverGroupOrder.contains((Object)scope)) {
            return this.isBefore(scope, serverGroupOrder);
        }
        if (serverProjectOrder.contains((Object)scope)) {
            return this.isBefore(scope, serverProjectOrder);
        }
        return false;
    }

    private boolean isBefore(Scope scope, List<Scope> order) {
        for (Scope s : order) {
            if (s.equals((Object)scope)) {
                return false;
            }
            if (!s.equals((Object)this)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }

    static {
        groupOrder = List.of(GUEST, REVIEWER, CONTRIBUTOR, MANAGER, APPROVER);
        projectOrder = List.of(PROJECT_CONTRIBUTOR, PROJECT_MANAGER);
        serverGroupOrder = List.of(SERVER_GUEST, SERVER_REVIEWER, SERVER_CONTRIBUTOR, SERVER_MANAGER, SERVER_APPROVER);
        serverProjectOrder = List.of(SERVER_PROJECT_CONTRIBUTOR, SERVER_PROJECT_MANAGER);
    }
}

