/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.oauth;

import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.oauth.Passwords;
import com.pageseeder.common.util.Base64;
import com.pageseeder.common.util.BinaryFormat;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.CreateFailedException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.InsertFailedException;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.jdo.JDOFatalInternalException;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PersistentToken
extends DBObject
implements Persistable {
    private static final int ENTROPY_BYTES = 24;
    private Long id;
    private @Nullable String tokenHash;
    private @Nullable Date issuedAt;
    private @Nullable Date expires;
    private @Nullable String scope;
    private @Nullable Client client;
    private @Nullable Member member;
    private @Nullable String data;
    private @Nullable String actualToken;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = PersistentToken.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = PersistentToken.__dnGetInheritedFieldCount();

    private PersistentToken() {
    }

    @Override
    public Long getId() {
        return PersistentToken.dnGetid(this);
    }

    public @Nullable Client getClient() {
        return PersistentToken.dnGetclient(this);
    }

    protected void setClient(@Nullable Client client) {
        PersistentToken.dnSetclient(this, client);
    }

    public @Nullable Member getMember() {
        return PersistentToken.dnGetmember(this);
    }

    protected void setMember(@Nullable Member member) {
        PersistentToken.dnSetmember(this, member);
    }

    protected @Nullable String getTokenHash() {
        return PersistentToken.dnGettokenHash(this);
    }

    protected void setTokenHash(String token) {
        PersistentToken.dnSettokenHash(this, token);
    }

    public @Nullable Date getIssuedAt() {
        return PersistentToken.dnGetissuedAt(this);
    }

    protected void setIssuedAt(Date issuedAt) {
        PersistentToken.dnSetissuedAt(this, issuedAt);
    }

    public @Nullable Date getExpires() {
        return PersistentToken.dnGetexpires(this);
    }

    protected void setExpires(Date expires) {
        PersistentToken.dnSetexpires(this, expires);
    }

    public @Nullable String getScope() {
        return PersistentToken.dnGetscope(this);
    }

    protected void setScope(@Nullable String scope) {
        PersistentToken.dnSetscope(this, scope);
    }

    public void setData(@Nullable String data) {
        PersistentToken.dnSetdata(this, data);
    }

    public @Nullable String getData() {
        return PersistentToken.dnGetdata(this);
    }

    public long maxAge(TimeUnit unit) {
        if (PersistentToken.dnGetissuedAt(this) == null) {
            throw new NullPointerException();
        }
        if (PersistentToken.dnGetexpires(this) == null) {
            return Integer.MAX_VALUE;
        }
        long lifetime = PersistentToken.dnGetexpires(this).getTime() - PersistentToken.dnGetissuedAt(this).getTime();
        return unit.convert(lifetime, TimeUnit.MILLISECONDS);
    }

    public boolean hasExpired() {
        return this.hasExpiredAt(new Date());
    }

    public boolean hasExpiredAt(Date time) {
        if (PersistentToken.dnGetexpires(this) == null) {
            return false;
        }
        return time.after(PersistentToken.dnGetexpires(this));
    }

    public @Nullable String getClientId() {
        Client c = this.getClient();
        return c != null ? c.getIdentifier() : null;
    }

    public @Nullable Long getMemberId() {
        Member m = this.getMember();
        return m != null ? m.getId() : null;
    }

    private void setActualToken(String token) {
        this.actualToken = token;
    }

    public @Nullable String getActualToken() {
        return this.actualToken;
    }

    public boolean hasPurpose(Purpose purpose) {
        return purpose.scope().equals(PersistentToken.dnGetscope(this));
    }

    public static PersistentToken issueRefreshToken(Database db, Client client, @Nullable Member member, @Nullable String scope) throws DatabaseException {
        long now = System.currentTimeMillis();
        long expires = now + client.getRefreshTokenMaxAge(TimeUnit.MILLISECONDS);
        String code = Passwords.randomBytes((int)24, (BinaryFormat)BinaryFormat.BASE_64_URL);
        PersistentToken token = PersistentToken.create(db);
        token.setActualToken(code);
        token.setTokenHash(PersistentToken.hash(code));
        token.setIssuedAt(new Date(now));
        token.setExpires(new Date(expires));
        token.setClient(client);
        token.setMember(member);
        token.setScope(scope);
        token.insert(db);
        client.updateLastToken();
        return token;
    }

    public static PersistentToken issuePSToken(Database db, Member member, Purpose purpose, @Nullable String data, @Nullable Duration expiration) throws DatabaseException {
        Date expiresDate;
        long now = System.currentTimeMillis();
        if (expiration != null) {
            expiresDate = Date.from(Instant.now().plus(expiration));
        } else {
            long expires = now + purpose.lifetime(TimeUnit.MILLISECONDS);
            expiresDate = new Date(expires);
        }
        String code = Passwords.randomBytes((int)24, (BinaryFormat)BinaryFormat.BASE_64_URL);
        PersistentToken token = PersistentToken.create(db);
        token.setActualToken(code);
        token.setTokenHash(PersistentToken.hash(code));
        token.setIssuedAt(new Date(now));
        token.setExpires(expiresDate);
        token.setClient(null);
        token.setMember(member);
        token.setScope(purpose.scope());
        token.setData(data);
        token.insert(db);
        return token;
    }

    public String toString() {
        return "persistent-token:" + PersistentToken.dnGetid(this) + " (" + PersistentToken.dnGettokenHash(this) + ")";
    }

    public void toXMLAttributes(XMLWriter xml, boolean includeToken) throws IOException {
        if (PersistentToken.dnGetid(this) != null) {
            xml.attribute("id", Long.toString(PersistentToken.dnGetid(this)));
        }
        xml.attribute("scope", PersistentToken.dnGetscope(this));
        xml.attribute("lifetime", Long.toString(this.maxAge(TimeUnit.SECONDS)));
        xml.attribute("issued", ISO8601.format((long)PersistentToken.dnGetissuedAt(this).getTime(), (ISO8601)ISO8601.DATETIME));
        xml.attribute("expires", ISO8601.format((long)PersistentToken.dnGetexpires(this).getTime(), (ISO8601)ISO8601.DATETIME));
        xml.attribute("expired", Boolean.toString(this.hasExpired()));
        if (this.actualToken != null && includeToken) {
            xml.attribute("token", this.actualToken);
        }
        if (PersistentToken.dnGetdata(this) != null) {
            xml.attribute("data", PersistentToken.dnGetdata(this));
        }
    }

    public static String hash(String token) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(token.getBytes(StandardCharsets.UTF_8));
            return new String(Base64.encode((byte[])hash));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
    }

    public static PersistentToken create(Database db) throws CreateFailedException {
        return new PersistentToken();
    }

    @Override
    public PersistentToken insert(Database db) throws InsertFailedException {
        return (PersistentToken)super.insert(db);
    }

    static {
        EnhancementHelper.registerClass((Class)PersistentToken.___dn$loadClass("com.pageseeder.db.oauth.PersistentToken"), (Persistable)new PersistentToken());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeObjectField(3, (Object)o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        PersistentToken result = new PersistentToken();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        PersistentToken result = new PersistentToken();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.client = (Client)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.data = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.expires = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.id = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.issuedAt = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 5: {
                this.member = (Member)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.scope = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.tokenHash = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.client);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.data);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.expires);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.id);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.issuedAt);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.member);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.scope);
                break;
            }
            case 7: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.tokenHash);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(PersistentToken obj, int index) {
        switch (index) {
            case 0: {
                this.client = obj.client;
                break;
            }
            case 1: {
                this.data = obj.data;
                break;
            }
            case 2: {
                this.expires = obj.expires;
                break;
            }
            case 3: {
                this.id = obj.id;
                break;
            }
            case 4: {
                this.issuedAt = obj.issuedAt;
                break;
            }
            case 5: {
                this.member = obj.member;
                break;
            }
            case 6: {
                this.scope = obj.scope;
                break;
            }
            case 7: {
                this.tokenHash = obj.tokenHash;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof PersistentToken)) {
            throw new IllegalArgumentException("object is not an object of type com.pageseeder.db.oauth.PersistentToken");
        }
        PersistentToken other = (PersistentToken)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"client", "data", "expires", "id", "issuedAt", "member", "scope", "tokenHash"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 8;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static Client dnGetclient(PersistentToken objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (Client)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, (Object)objPC.client);
        }
        return objPC.client;
    }

    private static void dnSetclient(PersistentToken objPC, Client val) {
        if (objPC.dnStateManager == null) {
            objPC.client = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, (Object)objPC.client, (Object)val);
        }
    }

    private static String dnGetdata(PersistentToken objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.data);
        }
        return objPC.data;
    }

    private static void dnSetdata(PersistentToken objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.data, val);
        } else {
            objPC.data = val;
        }
    }

    private static Date dnGetexpires(PersistentToken objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, (Object)objPC.expires);
        }
        return objPC.expires;
    }

    private static void dnSetexpires(PersistentToken objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, (Object)objPC.expires, (Object)val);
        } else {
            objPC.expires = val;
        }
    }

    private static Long dnGetid(PersistentToken objPC) {
        return objPC.id;
    }

    private static void dnSetid(PersistentToken objPC, Long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, (Object)objPC.id, (Object)val);
        }
    }

    private static Date dnGetissuedAt(PersistentToken objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 4, (Object)objPC.issuedAt);
        }
        return objPC.issuedAt;
    }

    private static void dnSetissuedAt(PersistentToken objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4, (Object)objPC.issuedAt, (Object)val);
        } else {
            objPC.issuedAt = val;
        }
    }

    private static Member dnGetmember(PersistentToken objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return (Member)objPC.dnStateManager.getObjectField((Persistable)objPC, 5, (Object)objPC.member);
        }
        return objPC.member;
    }

    private static void dnSetmember(PersistentToken objPC, Member val) {
        if (objPC.dnStateManager == null) {
            objPC.member = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5, (Object)objPC.member, (Object)val);
        }
    }

    private static String dnGetscope(PersistentToken objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6, objPC.scope);
        }
        return objPC.scope;
    }

    private static void dnSetscope(PersistentToken objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6, objPC.scope, val);
        } else {
            objPC.scope = val;
        }
    }

    private static String dnGettokenHash(PersistentToken objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 7, objPC.tokenHash);
        }
        return objPC.tokenHash;
    }

    private static void dnSettokenHash(PersistentToken objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 7, objPC.tokenHash, val);
        } else {
            objPC.tokenHash = val;
        }
    }

    public static enum Purpose {
        remember_me(90L, TimeUnit.DAYS, "ps:remember-me"),
        activate_member(2L, TimeUnit.DAYS, "ps:activate-member"),
        change_email(12L, TimeUnit.HOURS, "ps:change-email"),
        reset_password(12L, TimeUnit.HOURS, "ps:reset-password");

        private final long lifetimeMillis;
        private final String scope;

        private Purpose(long duration, TimeUnit unit, String scope) {
            this.lifetimeMillis = unit.toMillis(duration);
            this.scope = scope;
        }

        public long lifetime(TimeUnit unit) {
            return unit.convert(this.lifetimeMillis, TimeUnit.MILLISECONDS);
        }

        public String scope() {
            return this.scope;
        }
    }
}

