/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.oauth;

import com.pageseeder.common.oauth.GrantType;
import com.pageseeder.common.oauth.Passwords;
import com.pageseeder.common.util.BinaryFormat;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.InsertFailedException;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Scope;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jdo.JDOFatalInternalException;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Client
extends DBObject
implements Persistable {
    public static final long DEFAULT_ACCESS_TOKEN_MAX_AGE_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    public static final long DEFAULT_REFRESH_TOKEN_MAX_AGE_SECONDS = TimeUnit.DAYS.toSeconds(30L);
    private static final EnumSet<@NonNull GrantType> ALLOWED_GRANT_TYPES = EnumSet.of(GrantType.authorization_code, GrantType.password, GrantType.client_credentials);
    private Long id;
    private String identifier;
    private @Nullable String secretHash = null;
    private @Nullable String actualSecret = null;
    private @Nullable String name = null;
    private @Nullable String clientURI = null;
    private GrantType grant = GrantType.authorization_code;
    private @Nullable String description = null;
    private @Nullable String redirectURI = null;
    private @Nullable String scope = null;
    private @Nullable String webhookSecret = null;
    private @Nullable Date dateCreated = null;
    private @Nullable Date dateModified = null;
    private @Nullable Date dateLastToken = null;
    private @Nullable String appName = null;
    private Boolean requiresConsent = Boolean.FALSE;
    private Boolean confidential = Boolean.TRUE;
    private Long accessTokenMaxAge = DEFAULT_ACCESS_TOKEN_MAX_AGE_SECONDS;
    private Long refreshTokenMaxAge = DEFAULT_REFRESH_TOKEN_MAX_AGE_SECONDS;
    private Member member;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = Client.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = Client.__dnGetInheritedFieldCount();

    protected Client() {
        this.identifier = Passwords.randomBytes((int)8, (BinaryFormat)BinaryFormat.HEX).toLowerCase();
        this.dateCreated = new Date();
    }

    @Override
    public Long getId() {
        return Client.dnGetid(this);
    }

    public String getIdentifier() {
        return Client.dnGetidentifier(this);
    }

    public void setIdentifier(String identifier) {
        if (!Client.isValidIdentifier(identifier)) {
            throw new IllegalArgumentException("identifier");
        }
        Client.dnSetidentifier(this, identifier.toLowerCase());
    }

    public @Nullable String getClientURI() {
        return Client.dnGetclientURI(this);
    }

    public void setClientURI(String uri) {
        Client.dnSetclientURI(this, uri);
    }

    public @Nullable String getName() {
        return Client.dnGetname(this);
    }

    public void setName(String name) {
        Client.dnSetname(this, name);
    }

    public @Nullable String getDescription() {
        return Client.dnGetdescription(this);
    }

    public void setDescription(@Nullable String description) {
        Client.dnSetdescription(this, description);
    }

    public GrantType getGrantType() {
        return Client.dnGetgrant(this);
    }

    public void setGrant(GrantType grant) {
        if (!ALLOWED_GRANT_TYPES.contains(grant)) {
            throw new IllegalArgumentException("Unsupported grant type for client: " + String.valueOf(grant));
        }
        Client.dnSetgrant(this, grant);
    }

    public @Nullable String getAppName() {
        return Client.dnGetappName(this);
    }

    public void setAppName(@Nullable String name) {
        Client.dnSetappName(this, name);
    }

    public @Nullable Date getDateCreated() {
        return Client.dnGetdateCreated(this);
    }

    public @Nullable Date getDateModified() {
        return Client.dnGetdateModified(this);
    }

    public @Nullable Date getDateLastToken() {
        return Client.dnGetdateLastToken(this);
    }

    public void setDateCreated(Date date) {
        Client.dnSetdateCreated(this, date);
    }

    public void setDateModified(Date date) {
        Client.dnSetdateModified(this, date);
    }

    public void setDateLastToken(Date date) {
        Client.dnSetdateLastToken(this, date);
    }

    public void updateLastToken() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime hours = now.truncatedTo(ChronoUnit.HOURS);
        Date datehours = Date.from(hours.atZone(ZoneId.systemDefault()).toInstant());
        if (Client.dnGetdateLastToken(this) == null || Client.dnGetdateLastToken(this).before(datehours)) {
            Client.dnSetdateLastToken(this, datehours);
        }
    }

    public void setWebhookSecret(@Nullable String secret) {
        Client.dnSetwebhookSecret(this, secret);
    }

    public @Nullable String getWebhookSecret() {
        return Client.dnGetwebhookSecret(this);
    }

    public Boolean getRequiresConsent() {
        return Client.dnGetrequiresConsent(this);
    }

    public Boolean getConfidential() {
        return Client.dnGetconfidential(this);
    }

    public @Nullable String getRedirectURI() {
        return Client.dnGetredirectURI(this);
    }

    public void setRedirectURI(String redirectURI) {
        Client.dnSetredirectURI(this, redirectURI);
    }

    public @Nullable String getSecretHash() {
        return Client.dnGetsecretHash(this);
    }

    protected void setSecretHash(String secret) {
        Client.dnSetsecretHash(this, secret);
    }

    public void setRequiresConsent(boolean yes) {
        Client.dnSetrequiresConsent(this, yes);
    }

    public void setConfidential(boolean confidential) {
        Client.dnSetconfidential(this, confidential);
    }

    protected void setAccessTokenMaxAge(long seconds) {
        Client.dnSetaccessTokenMaxAge(this, seconds);
    }

    protected void setRefreshTokenMaxAge(long seconds) {
        Client.dnSetrefreshTokenMaxAge(this, seconds);
    }

    public void setAccessTokenMaxAge(long duration, TimeUnit unit) {
        Client.dnSetaccessTokenMaxAge(this, unit.toSeconds(duration));
    }

    public void setRefreshTokenMaxAge(long duration, TimeUnit unit) {
        Client.dnSetrefreshTokenMaxAge(this, unit.toSeconds(duration));
    }

    public long getAccessTokenMaxAge(TimeUnit unit) {
        return unit.convert(Client.dnGetaccessTokenMaxAge(this), TimeUnit.SECONDS);
    }

    public long getRefreshTokenMaxAge(TimeUnit unit) {
        return unit.convert(Client.dnGetrefreshTokenMaxAge(this), TimeUnit.SECONDS);
    }

    public @Nullable String getScope() {
        return Client.dnGetscope(this);
    }

    public void setScope(String scope) {
        Client.dnSetscope(this, scope);
    }

    public Member getMember() {
        return Client.dnGetmember(this);
    }

    public void setMember(Member member) {
        Client.dnSetmember(this, member);
    }

    public final void setActualSecret(String secret) {
        this.actualSecret = secret;
        Client.dnSetsecretHash(this, Passwords.hash((char[])secret.toCharArray()));
    }

    public final Set<Scope> getScopes() {
        return Scope.fromDelimitedString(Client.dnGetscope(this));
    }

    public final Set<Scope> filterScopes(Collection<Scope> scopes) {
        if (Strings.isEmpty((String)Client.dnGetscope(this))) {
            return Collections.emptySet();
        }
        return Scope.filterScopes(scopes, this.getScopes());
    }

    public final String filterScopes(String scope) {
        return Scope.join(" ", this.filterScopes(Scope.fromDelimitedString(scope)));
    }

    public final boolean isClientSecret(String secret) {
        char[] maybe = secret.toCharArray();
        return Passwords.match((char[])maybe, (String)Client.dnGetsecretHash(this));
    }

    public final boolean isValidRedirectURI(@Nullable String uri) {
        if (uri == null || !uri.startsWith("https://")) {
            return false;
        }
        String thisRedirectURI = Client.dnGetredirectURI(this);
        if (thisRedirectURI == null || thisRedirectURI.isEmpty()) {
            return false;
        }
        try {
            URI url = new URI(uri);
            if (url.getFragment() != null && !url.getFragment().isEmpty()) {
                return false;
            }
            return uri.equals(thisRedirectURI);
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    public String toString() {
        return "client:" + Client.dnGetid(this) + " (" + Client.dnGetidentifier(this) + ")";
    }

    public static boolean isValidIdentifier(@Nullable String identifier) {
        return identifier != null && identifier.length() == 16 && Strings.isHex((String)identifier);
    }

    public static Client create(Database db) {
        return new Client();
    }

    @Override
    public Client insert(Database db) throws InsertFailedException {
        return (Client)super.insert(db);
    }

    static {
        EnhancementHelper.registerClass((Class)Client.___dn$loadClass("com.pageseeder.db.oauth.Client"), (Persistable)new Client());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeObjectField(9, (Object)o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        Client result = new Client();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        Client result = new Client();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.accessTokenMaxAge = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.appName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.clientURI = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.confidential = (Boolean)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.dateCreated = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 5: {
                this.dateLastToken = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.dateModified = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 7: {
                this.description = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 8: {
                this.grant = (GrantType)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 9: {
                this.id = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 10: {
                this.identifier = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 11: {
                this.member = (Member)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 12: {
                this.name = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 13: {
                this.redirectURI = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 14: {
                this.refreshTokenMaxAge = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 15: {
                this.requiresConsent = (Boolean)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 16: {
                this.scope = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 17: {
                this.secretHash = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 18: {
                this.webhookSecret = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.accessTokenMaxAge);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.appName);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.clientURI);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.confidential);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.dateCreated);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.dateLastToken);
                break;
            }
            case 6: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.dateModified);
                break;
            }
            case 7: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.description);
                break;
            }
            case 8: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.grant);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.id);
                break;
            }
            case 10: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.identifier);
                break;
            }
            case 11: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.member);
                break;
            }
            case 12: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.name);
                break;
            }
            case 13: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.redirectURI);
                break;
            }
            case 14: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.refreshTokenMaxAge);
                break;
            }
            case 15: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.requiresConsent);
                break;
            }
            case 16: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.scope);
                break;
            }
            case 17: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.secretHash);
                break;
            }
            case 18: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.webhookSecret);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(Client obj, int index) {
        switch (index) {
            case 0: {
                this.accessTokenMaxAge = obj.accessTokenMaxAge;
                break;
            }
            case 1: {
                this.appName = obj.appName;
                break;
            }
            case 2: {
                this.clientURI = obj.clientURI;
                break;
            }
            case 3: {
                this.confidential = obj.confidential;
                break;
            }
            case 4: {
                this.dateCreated = obj.dateCreated;
                break;
            }
            case 5: {
                this.dateLastToken = obj.dateLastToken;
                break;
            }
            case 6: {
                this.dateModified = obj.dateModified;
                break;
            }
            case 7: {
                this.description = obj.description;
                break;
            }
            case 8: {
                this.grant = obj.grant;
                break;
            }
            case 9: {
                this.id = obj.id;
                break;
            }
            case 10: {
                this.identifier = obj.identifier;
                break;
            }
            case 11: {
                this.member = obj.member;
                break;
            }
            case 12: {
                this.name = obj.name;
                break;
            }
            case 13: {
                this.redirectURI = obj.redirectURI;
                break;
            }
            case 14: {
                this.refreshTokenMaxAge = obj.refreshTokenMaxAge;
                break;
            }
            case 15: {
                this.requiresConsent = obj.requiresConsent;
                break;
            }
            case 16: {
                this.scope = obj.scope;
                break;
            }
            case 17: {
                this.secretHash = obj.secretHash;
                break;
            }
            case 18: {
                this.webhookSecret = obj.webhookSecret;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Client)) {
            throw new IllegalArgumentException("object is not an object of type com.pageseeder.db.oauth.Client");
        }
        Client other = (Client)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"accessTokenMaxAge", "appName", "clientURI", "confidential", "dateCreated", "dateLastToken", "dateModified", "description", "grant", "id", "identifier", "member", "name", "redirectURI", "refreshTokenMaxAge", "requiresConsent", "scope", "secretHash", "webhookSecret"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 19;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static Long dnGetaccessTokenMaxAge(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (Long)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, (Object)objPC.accessTokenMaxAge);
        }
        return objPC.accessTokenMaxAge;
    }

    private static void dnSetaccessTokenMaxAge(Client objPC, Long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, (Object)objPC.accessTokenMaxAge, (Object)val);
        } else {
            objPC.accessTokenMaxAge = val;
        }
    }

    private static String dnGetappName(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.appName);
        }
        return objPC.appName;
    }

    private static void dnSetappName(Client objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.appName, val);
        } else {
            objPC.appName = val;
        }
    }

    private static String dnGetclientURI(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2, objPC.clientURI);
        }
        return objPC.clientURI;
    }

    private static void dnSetclientURI(Client objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2, objPC.clientURI, val);
        } else {
            objPC.clientURI = val;
        }
    }

    private static Boolean dnGetconfidential(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return (Boolean)objPC.dnStateManager.getObjectField((Persistable)objPC, 3, (Object)objPC.confidential);
        }
        return objPC.confidential;
    }

    private static void dnSetconfidential(Client objPC, Boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, (Object)objPC.confidential, (Object)val);
        } else {
            objPC.confidential = val;
        }
    }

    private static Date dnGetdateCreated(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 4, (Object)objPC.dateCreated);
        }
        return objPC.dateCreated;
    }

    private static void dnSetdateCreated(Client objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4, (Object)objPC.dateCreated, (Object)val);
        } else {
            objPC.dateCreated = val;
        }
    }

    private static Date dnGetdateLastToken(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 5, (Object)objPC.dateLastToken);
        }
        return objPC.dateLastToken;
    }

    private static void dnSetdateLastToken(Client objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5, (Object)objPC.dateLastToken, (Object)val);
        } else {
            objPC.dateLastToken = val;
        }
    }

    private static Date dnGetdateModified(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 6, (Object)objPC.dateModified);
        }
        return objPC.dateModified;
    }

    private static void dnSetdateModified(Client objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 6, (Object)objPC.dateModified, (Object)val);
        } else {
            objPC.dateModified = val;
        }
    }

    private static String dnGetdescription(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 7, objPC.description);
        }
        return objPC.description;
    }

    private static void dnSetdescription(Client objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 7, objPC.description, val);
        } else {
            objPC.description = val;
        }
    }

    private static GrantType dnGetgrant(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8)) {
            return (GrantType)objPC.dnStateManager.getObjectField((Persistable)objPC, 8, (Object)objPC.grant);
        }
        return objPC.grant;
    }

    private static void dnSetgrant(Client objPC, GrantType val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 8, (Object)objPC.grant, (Object)val);
        } else {
            objPC.grant = val;
        }
    }

    private static Long dnGetid(Client objPC) {
        return objPC.id;
    }

    private static void dnSetid(Client objPC, Long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9, (Object)objPC.id, (Object)val);
        }
    }

    private static String dnGetidentifier(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 10)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 10, objPC.identifier);
        }
        return objPC.identifier;
    }

    private static void dnSetidentifier(Client objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 10, objPC.identifier, val);
        } else {
            objPC.identifier = val;
        }
    }

    private static Member dnGetmember(Client objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 11)) {
            return (Member)objPC.dnStateManager.getObjectField((Persistable)objPC, 11, (Object)objPC.member);
        }
        return objPC.member;
    }

    private static void dnSetmember(Client objPC, Member val) {
        if (objPC.dnStateManager == null) {
            objPC.member = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 11, (Object)objPC.member, (Object)val);
        }
    }

    private static String dnGetname(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 12)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 12, objPC.name);
        }
        return objPC.name;
    }

    private static void dnSetname(Client objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 12, objPC.name, val);
        } else {
            objPC.name = val;
        }
    }

    private static String dnGetredirectURI(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 13)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 13, objPC.redirectURI);
        }
        return objPC.redirectURI;
    }

    private static void dnSetredirectURI(Client objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 13, objPC.redirectURI, val);
        } else {
            objPC.redirectURI = val;
        }
    }

    private static Long dnGetrefreshTokenMaxAge(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 14)) {
            return (Long)objPC.dnStateManager.getObjectField((Persistable)objPC, 14, (Object)objPC.refreshTokenMaxAge);
        }
        return objPC.refreshTokenMaxAge;
    }

    private static void dnSetrefreshTokenMaxAge(Client objPC, Long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 14, (Object)objPC.refreshTokenMaxAge, (Object)val);
        } else {
            objPC.refreshTokenMaxAge = val;
        }
    }

    private static Boolean dnGetrequiresConsent(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 15)) {
            return (Boolean)objPC.dnStateManager.getObjectField((Persistable)objPC, 15, (Object)objPC.requiresConsent);
        }
        return objPC.requiresConsent;
    }

    private static void dnSetrequiresConsent(Client objPC, Boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 15, (Object)objPC.requiresConsent, (Object)val);
        } else {
            objPC.requiresConsent = val;
        }
    }

    private static String dnGetscope(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 16)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 16, objPC.scope);
        }
        return objPC.scope;
    }

    private static void dnSetscope(Client objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 16, objPC.scope, val);
        } else {
            objPC.scope = val;
        }
    }

    private static String dnGetsecretHash(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 17)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 17, objPC.secretHash);
        }
        return objPC.secretHash;
    }

    private static void dnSetsecretHash(Client objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 17, objPC.secretHash, val);
        } else {
            objPC.secretHash = val;
        }
    }

    private static String dnGetwebhookSecret(Client objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 18)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 18, objPC.webhookSecret);
        }
        return objPC.webhookSecret;
    }

    private static void dnSetwebhookSecret(Client objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 18, objPC.webhookSecret, val);
        } else {
            objPC.webhookSecret = val;
        }
    }
}

