/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.common.properties.GlobalSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class ReverseXRefs {
    public static final int MAX_REVERSE_XREFS = 1000;
    private final Map<String, Collection<Long>> xrefs = new HashMap<String, Collection<Long>>();
    private final int max = GlobalSettings.getInt((String)"maxReverseXRefs", (int)1000);
    private int size = 0;
    private final boolean reachedMax;

    public ReverseXRefs(int size) {
        this.reachedMax = size > this.max;
    }

    public void addReverseXRef(String frag, Long xlinkId) {
        if (this.size >= this.max) {
            return;
        }
        Collection ids = this.xrefs.computeIfAbsent(frag, k -> new ArrayList());
        if (!ids.contains(xlinkId)) {
            ids.add(xlinkId);
            ++this.size;
        }
    }

    public @Nullable Collection<Long> getReverseXRefs(String frag) {
        return this.xrefs.get(frag);
    }

    public boolean isLimitReached() {
        return this.reachedMax;
    }
}

