/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.util.Date;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public class Publication {
    public static final String DEFAULT_TYPE = "default";
    private final String id;
    private final long hostId;
    private final long rootURIId;
    private final @Nullable Date rootModified;
    private final @Nullable String title;
    private final long xlinkId;
    private final long defaultGroupId;
    private final @Nullable String type;

    public Publication(XLink xlink, URI root, Group group) {
        this.id = xlink.getContentTitle();
        this.hostId = root.getHost().getId();
        this.rootURIId = root.getId();
        this.rootModified = root.getLastModified();
        this.title = root.getDisplayTitle();
        this.xlinkId = xlink.getId();
        this.defaultGroupId = group.getId();
        this.type = xlink.getType();
    }

    public Publication(String id, long hostId, long rootURIId, @Nullable Date rootModified, @Nullable String title, long xlinkId, long defaultGroupId, String type) {
        this.id = id;
        this.hostId = hostId;
        this.rootURIId = rootURIId;
        this.rootModified = rootModified;
        this.title = title;
        this.xlinkId = xlinkId;
        this.defaultGroupId = defaultGroupId;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public long getHostId() {
        return this.hostId;
    }

    public long getDefaultGroupId() {
        return this.defaultGroupId;
    }

    public long getRootURIId() {
        return this.rootURIId;
    }

    public Date getRootModified() {
        return this.rootModified;
    }

    public @Nullable String getTitle() {
        return this.title;
    }

    public long getXLinkId() {
        return this.xlinkId;
    }

    public @Nullable String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Publication that = (Publication)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

