/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db;

import com.pageseeder.common.properties.DatabaseSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.db.OpenDatabaseException;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public class Database
implements AutoCloseable {
    private static @Nullable PersistenceManagerFactory pmf = null;
    private static @Nullable String errorMessage = null;
    private PersistenceManager pm;

    private Database() {
        if (pmf == null) {
            int fourHoursInSeconds = 14400;
            System.setProperty("c3p0.maxIdleTime", "14400");
            pmf = JDOHelper.getPersistenceManagerFactory((Map)this.getJDOProperties());
        }
        this.pm = pmf.getPersistenceManager();
    }

    private Properties getJDOProperties() {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)Settings.getProperties((SettingsFile)SettingsFile.JDO));
        String url = DatabaseSettings.get((String)"DBURL");
        if (url == null) {
            throw new NullPointerException("Database URL not specified, run Setup first.");
        }
        prop.setProperty("javax.jdo.option.ConnectionURL", url);
        prop.setProperty("javax.jdo.option.ConnectionDriverName", DatabaseSettings.get((String)"DBDriver"));
        prop.setProperty("javax.jdo.option.ConnectionUserName", DatabaseSettings.get((String)"LoginName"));
        prop.setProperty("javax.jdo.option.ConnectionPassword", DatabaseSettings.getPassword());
        prop.setProperty("datanucleus.connectionPool.maxPoolSize", DatabaseSettings.getString((String)"MaxConnections", (String)"100"));
        prop.setProperty("datanucleus.query.sql.allowAll", "true");
        if ("PostgreSQL".equals(DatabaseSettings.get((String)"DatabaseType"))) {
            prop.setProperty("datanucleus.identifier.case", "LowerCase");
        }
        return prop;
    }

    public static void setError(String message) {
        errorMessage = message;
    }

    public static Database open() throws OpenDatabaseException {
        if (errorMessage != null) {
            throw new OpenDatabaseException(errorMessage);
        }
        try {
            return new Database();
        }
        catch (JDOException ex) {
            throw new OpenDatabaseException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (NullPointerException ex) {
            throw new OpenDatabaseException(ex.getMessage());
        }
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public void restartPersistenceManager() {
        Transaction tr = this.pm.currentTransaction();
        if (tr != null && tr.isActive()) {
            tr.commit();
        }
        this.pm.close();
        this.pm = pmf.getPersistenceManager();
    }

    public void discardCache() {
    }

    @Override
    public void close() {
        if (this.pm == null) {
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            String current = st.length > 2 ? st[2].getClassName() : "Unknown class";
            LoggerFactory.getLogger(Database.class).warn(current + " trying to close already closed database connection.");
            return;
        }
        Transaction tr = this.pm.currentTransaction();
        if (tr != null && tr.isActive()) {
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            String current = st.length > 2 ? st[2].getClassName() : "Unknown class";
            LoggerFactory.getLogger(Database.class).warn(current + " rolling back Transaction left open.");
            tr.rollback();
        }
        this.pm.close();
        this.pm = null;
    }

    public static void closeAll() {
        if (pmf != null) {
            try {
                pmf.close();
            }
            catch (JDOUserException ex) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                pmf.close();
            }
        }
    }

    public static void reloadConfig() {
        if (pmf != null && !pmf.isClosed()) {
            throw new IllegalStateException("Persistence manager factory must be closed before reloading.");
        }
        pmf = null;
    }
}

