/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.utils;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.w3c.dom.Node;

public final class XMLTools {
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();

    private XMLTools() {
    }

    public static String xmlAttr(String name, @Nullable String value) {
        if (value == null) {
            return name + "=''";
        }
        return name + "='" + value.replace("'", "&#039;") + "'";
    }

    public static String escape(@Nullable String text) {
        StringBuilder xml = new StringBuilder();
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if ((c >= ' ' && c <= '\ud7ff' || c == '\t' || c == '\n' || c == '\r' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') && (c < '\u007f' || c > '\u009f')) {
                    switch (c) {
                        case '>': {
                            xml.append("&gt;");
                            break;
                        }
                        case '<': {
                            xml.append("&lt;");
                            break;
                        }
                        case '&': {
                            xml.append("&amp;");
                            break;
                        }
                        default: {
                            xml.append(c);
                            break;
                        }
                    }
                    continue;
                }
                xml.append('?');
            }
        }
        return xml.toString();
    }

    public static String evalXPath(Node node, String xpath) {
        try {
            XPath xpathObj = XPATH_FACTORY.newXPath();
            Object value = xpathObj.evaluate(xpath, node, XPathConstants.STRING);
            if (value instanceof String) {
                return (String)value;
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }
}

