/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.remote;

import com.pageseeder.common.http.HttpWebRequest;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.publisher.core.PublishManager;
import com.pageseeder.publisher.exceptions.AlreadyRunningException;
import com.pageseeder.publisher.utils.ServletUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriterImpl;

public final class Publisher
extends HttpServlet {
    private static final long serialVersionUID = 5612132203587891761L;
    private @Nullable File webapp = null;

    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        Object contextPath = this.getServletContext().getRealPath("/");
        if (!((String)contextPath).endsWith(File.separator)) {
            contextPath = (String)contextPath + File.separatorChar;
        }
        this.webapp = new File((String)contextPath);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.doGet(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HttpWebRequest wreq = new HttpWebRequest(req, res);
        String action = wreq.getParameter("action", true);
        if (wreq.hasError()) {
            return;
        }
        if (action == null) {
            return;
        }
        try (StringWriter sout = new StringWriter();){
            if ("check".equals(action)) {
                String processID = wreq.getParameter("ps-processId");
                if (processID != null) {
                    this.progress(PublishManager.getInstance().getProgressMessage(processID, true), sout);
                } else {
                    this.progress(PublishManager.getInstance().getProgressMessage(this.buildProperties(req, false), true), sout);
                }
            } else if ("peek".equals(action)) {
                this.peek(req, sout);
            } else if ("publish".equals(action)) {
                this.publish(wreq, sout);
            } else if ("cancel".equals(action)) {
                this.cancel(req, sout);
            } else {
                String msg = "Invalid action parameter specified";
                ServletUtils.writeError(String.valueOf(System.currentTimeMillis()), "Invalid Action", msg, null, sout);
                res.sendError(400, msg);
            }
        }
        res.setContentType("application/xml; charset=UTF-8");
        res.setCharacterEncoding("utf-8");
        PrintWriter out = res.getWriter();
        out.append(((Object)sout).toString());
        out.close();
    }

    private void publish(HttpWebRequest wreq, Writer resout) throws IOException {
        File previewScript;
        String target = wreq.getParameter("target", true);
        String processID = wreq.getParameter("ps-processId");
        String project = wreq.getParameter("source-projectname");
        String source = wreq.getParameter("source-type");
        String extension = wreq.getParameter("ps-uriExtension", wreq.getParameter("ps-uploadExtension"));
        String action = wreq.getParameter("source-actiontype");
        String doctype = wreq.getParameter("source-documenttype");
        String urltype = wreq.getParameter("source-urltype");
        String logLevel = wreq.getParameter("log-level");
        boolean downloadWorking = "true".equals(wreq.getParameter("download-working"));
        if (wreq.hasError()) {
            return;
        }
        File publishScript = this.getPublishScriptNew(project, source, extension, doctype, urltype, action);
        if (!publishScript.exists() && "upload".equals(action) && (previewScript = this.getPublishScriptNew(project, source, extension, doctype, urltype, "upload-preview")).exists()) {
            publishScript = previewScript;
        }
        if (!publishScript.exists()) {
            ServletUtils.writeError(processID, "Publish Script Not Found", "The publish script " + Files.path((File)this.webapp, (File)publishScript) + " was not found", this.buildProperties(wreq.request(), false), resout);
            return;
        }
        try {
            PublishManager.getInstance().publish(processID, publishScript, target, logLevel, downloadWorking, this.buildProperties(wreq.request(), true));
        }
        catch (AlreadyRunningException ex) {
            ServletUtils.alreadyRunning(processID, ex, this.buildProperties(wreq.request(), false), resout);
            return;
        }
        this.progress(PublishManager.getInstance().getProgressMessage(processID, true), resout);
    }

    private Map<String, String> buildProperties(HttpServletRequest req, boolean forPublish) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration pns = req.getParameterNames();
        while (pns.hasMoreElements()) {
            String name = (String)pns.nextElement();
            if (!name.startsWith("ps-") && !name.startsWith("target-") && !name.startsWith("style-")) continue;
            String value = req.getParameter(name);
            if (name.startsWith("style-")) {
                properties.put("ps-" + name, value);
                continue;
            }
            properties.put(name, value);
        }
        if (!forPublish) {
            return properties;
        }
        if (properties.containsKey("ps-groupTemplate")) {
            properties.put("ps-style-owner", (String)properties.get("ps-groupTemplate"));
        }
        if (properties.containsKey("ps-globalTemplate")) {
            properties.put("ps-customFolder", (String)properties.get("ps-globalTemplate"));
        }
        File publishRoot = new File(Settings.getContextPath(), "/WEB-INF/state/publish");
        File workingRoot = new File(publishRoot, "working");
        properties.put("ps-working", new File(workingRoot, this.buildWorkingFolder(req)).getCanonicalPath());
        properties.put("ps-workingRoot", workingRoot.getCanonicalPath());
        properties.put("ps-webRoot", publishRoot.getCanonicalPath());
        properties.put("ps-engineUrl", GlobalSettings.get((String)"webSiteScheme") + "://" + GlobalSettings.get((String)"webSiteAddress") + ":" + GlobalSettings.get((String)"webSitePort") + GlobalSettings.getSitePrefix() + "/publish");
        String jsessionid = req.getParameter("ps-jsessionid");
        if (jsessionid != null) {
            properties.put("ps-sessionfolder", PublishManager.createSessionFolder(jsessionid));
        } else if (properties.containsKey("ps-username")) {
            properties.put("ps-sessionfolder", PublishManager.createSessionFolder((String)properties.get("ps-username")));
        }
        return properties;
    }

    private String buildWorkingFolder(HttpServletRequest req) {
        String gpfolder;
        String host;
        String uripath = req.getParameter("ps-uriPath");
        String uploadPath = req.getParameter("ps-uploadPath");
        boolean isFolder = "folder".equals(req.getParameter("uri-type"));
        String pshost = req.getParameter("ps-host");
        if (pshost == null) {
            pshost = "";
        }
        String work = uripath != null ? ((host = req.getParameter("ps-uriHost")) == null ? pshost : host) + uripath + (isFolder ? "/ps-folder" : "/ps-uri") : (uploadPath != null ? pshost + "/ps-users/" + req.getParameter("ps-username") + (uploadPath.charAt(0) == '/' ? "" : "/") + uploadPath + "/ps-upload" : pshost + ((gpfolder = req.getParameter("ps-groupFolder")) == null ? "" : gpfolder) + "/ps-group");
        return work.replace("..", "_");
    }

    private void cancel(HttpServletRequest req, Writer out) throws IOException {
        String processID = req.getParameter("ps-processId");
        PublishManager manager = PublishManager.getInstance();
        if (processID != null) {
            manager.cancel(processID);
            Map<String, StringBuffer> msgs = manager.peek(Collections.singleton(processID));
            XMLWriterImpl xml = new XMLWriterImpl(out);
            xml.openElement("cancel");
            xml.writeXML(msgs.get(processID).toString());
            xml.closeElement();
        } else {
            Map<String, String> props = this.buildProperties(req, false);
            manager.cancel(props);
            this.progress(manager.getProgressMessage(props, true), out);
        }
    }

    private void peek(HttpServletRequest req, Writer out) throws IOException {
        String[] processIDs = req.getParameterValues("ps-processId");
        Map<String, StringBuffer> msgs = PublishManager.getInstance().peek(processIDs == null || processIDs.length == 0 ? null : Arrays.asList(processIDs));
        XMLWriterImpl xml = new XMLWriterImpl(out);
        xml.openElement("peeks", true);
        for (StringBuffer value : msgs.values()) {
            xml.writeXML(value.toString());
        }
        xml.closeElement();
    }

    private void progress(StringBuffer sb, Writer out) throws IOException {
        XMLWriterImpl xml = new XMLWriterImpl(out);
        xml.openElement("check");
        xml.writeXML(sb.toString());
        xml.closeElement();
    }

    private File getPublishScriptNew(String project, String source, String extension, String doctype, String urltype, String action) throws IOException {
        File templates = new File(this.webapp, "WEB-INF" + (String)("default".equals(project) ? "" : File.separator + "config") + File.separator + "template");
        String scriptPath = "schedule".equals(source) ? project + File.separator + source + File.separator + "build.xml" : project + File.separator + (String)(Strings.isEmpty((String)doctype) ? source + File.separator : "") + (String)("url".equals(source) || !"document".equals(source) || Strings.isEmpty((String)extension) ? "" : extension.toLowerCase() + File.separator) + (String)(Strings.isEmpty((String)doctype) ? "" : doctype + File.separator) + (String)(Strings.isEmpty((String)urltype) ? ("url".equals(source) ? "default" : "") : urltype + File.separator) + action + File.separator + "build.xml";
        return Files.descendantFile((File)templates, (String)scriptPath);
    }
}

