/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.core;

import com.pageseeder.publisher.core.PublishThread;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;

public final class PublishThreadList {
    private final Map<String, PublishThread> threads = new ConcurrentHashMap<String, PublishThread>();
    private final Map<String, String> workingfolders = new ConcurrentHashMap<String, String>();
    private final Map<String, String> ids = new ConcurrentHashMap<String, String>();

    public void add(String processID, String processKey, PublishThread publishThread, String workingFolder) {
        this.ids.put(processKey, processID);
        this.threads.put(processID, publishThread);
        this.workingfolders.put(processID, workingFolder);
    }

    public List<String> getIDs() {
        return new ArrayList<String>(this.ids.values());
    }

    public @Nullable PublishThread getWithID(@Nullable String id) {
        if (id != null) {
            return this.threads.get(id);
        }
        return null;
    }

    public boolean hasWorkingFolder(String folder) {
        return this.workingfolders.containsValue(folder);
    }

    public @Nullable PublishThread getWithKey(String key) {
        return this.getWithID(this.ids.get(key));
    }

    public @Nullable PublishThread removeWithKey(String key) {
        String id = this.ids.remove(key);
        if (id != null) {
            this.workingfolders.remove(id);
            return this.threads.remove(id);
        }
        return null;
    }

    public @Nullable PublishThread removeWithID(@Nullable String id) {
        if (id != null) {
            String key = null;
            for (Map.Entry<String, String> i : this.ids.entrySet()) {
                if (!id.equals(i.getValue())) continue;
                key = i.getKey();
                break;
            }
            if (key != null) {
                this.ids.remove(key);
            }
            this.workingfolders.remove(id);
            return this.threads.remove(id);
        }
        return null;
    }

    public boolean hasKey(String key) {
        return this.getWithID(this.ids.get(key)) != null;
    }
}

