/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.ant;

import com.pageseeder.publisher.exceptions.BuildCancelledException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.eclipse.jdt.annotation.Nullable;

public final class AntRunner {
    private Project project = new Project();

    public void addListener(BuildListener listener) {
        this.project.addBuildListener(listener);
    }

    public void init(@Nullable String buildFile, @Nullable String baseDir, @Nullable Map<String, String> inputs) throws BuildException {
        this.project.init();
        File buildfile = new File(buildFile == null ? "build.xml" : buildFile);
        if (!buildfile.exists() || !buildfile.isFile()) {
            throw new BuildException("Configuration file " + String.valueOf(buildfile) + " is invalid.");
        }
        String dir = baseDir;
        if (dir == null) {
            try {
                dir = buildfile.getParentFile().getCanonicalPath();
            }
            catch (IOException e) {
                dir = buildfile.getParentFile().getAbsolutePath();
            }
        }
        try {
            this.project.setBasedir(dir);
        }
        catch (BuildException e) {
            throw new BuildException("The given basedir doesn't exist, or isn't a directory.", (Throwable)e);
        }
        try {
            ProjectHelper.configureProject((Project)this.project, (File)buildfile);
        }
        catch (BuildException e) {
            throw new BuildException("Configuration file " + String.valueOf(buildfile) + " cannot be read: " + e.getMessage(), (Throwable)e);
        }
        String workingFolder = this.project.getProperty("ps-working");
        if (workingFolder != null) {
            File working = new File(workingFolder);
            if (working.exists()) {
                try {
                    FileUtils.deleteDirectory((File)working);
                }
                catch (IOException ex) {
                    this.project.log("Failed to delete working folder: " + ex.getMessage(), 1);
                }
            }
            working.mkdirs();
            if (!working.exists()) {
                this.project.log("Failed to create working folder", 1);
            }
        } else {
            this.project.log("Working folder not found!", 1);
        }
    }

    public void setProperties(@Nullable Map<String, String> properties, boolean overridable) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String name = property.getKey();
            String value = property.getValue();
            if (!name.startsWith("ps-")) continue;
            if (name.startsWith("ps-param-")) {
                name = name.replaceFirst("ps-param-", "ps.param.");
            }
            if (overridable) {
                this.project.setProperty(name, value);
                continue;
            }
            this.project.setUserProperty(name, value);
        }
    }

    public void runTarget(@Nullable String target) {
        try {
            this.project.executeTarget(target == null ? this.project.getDefaultTarget() : target);
        }
        catch (ThreadDeath cancelled) {
            throw new BuildCancelledException();
        }
        catch (BuildCancelledException cancelled) {
            throw cancelled;
        }
        catch (BuildException ex) {
            if ("java.lang.ThreadDeath".equals(ex.getMessage())) {
                throw new BuildCancelledException();
            }
            throw ex;
        }
        catch (Throwable ex) {
            if (ex.getCause() instanceof ThreadDeath) {
                throw new BuildCancelledException();
            }
            throw new BuildException("Unknown error", ex);
        }
    }

    public void destroy() {
        this.project = null;
    }
}

