/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.ant;

import com.pageseeder.publisher.ant.AntLogMessage;
import com.pageseeder.publisher.core.PublishThread;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;

public final class AntMessageListener
implements BuildListener {
    private final PublishThread messageReceiver;
    private final int messagePriority;

    public AntMessageListener(PublishThread msgRec) {
        this(msgRec, 2);
    }

    public AntMessageListener(PublishThread receiver, int minPriority) {
        this.messageReceiver = receiver;
        this.messagePriority = minPriority;
    }

    public void targetStarted(BuildEvent event) {
        this.filterAndPush(event, AntLogMessage.MessageType.TARGETSTART);
    }

    public void targetFinished(BuildEvent event) {
        this.filterAndPush(event, AntLogMessage.MessageType.TARGETEND);
    }

    private void filterAndPush(BuildEvent event, AntLogMessage.MessageType type) {
        if (type.getPriority() > this.messagePriority) {
            return;
        }
        this.messageReceiver.pushAntLogMessage(new AntLogMessage(type, event.getMessage(), null, event.getTarget() == null ? null : event.getTarget().getName(), event.getTask() == null ? null : event.getTask().getTaskName()));
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() > this.messagePriority) {
            return;
        }
        if (event.getMessage() == null || event.getMessage().trim().isEmpty()) {
            return;
        }
        if (event.getTask() != null && event.getMessage() != null && "input".equals(event.getTask().getTaskName()) && event.getMessage().startsWith("skipping input as property ")) {
            return;
        }
        AntLogMessage msg = new AntLogMessage(event);
        if (msg.getType().getPriority() > this.messagePriority) {
            return;
        }
        this.messageReceiver.pushAntLogMessage(msg);
    }

    public void buildFinished(BuildEvent event) {
    }

    public void buildStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }
}

