/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.ant;

import com.pageseeder.publisher.utils.XMLTools;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class AntLogMessage {
    private final @Nullable String target;
    private final @Nullable String task;
    private final @Nullable String msg;
    private final @Nullable MessageType type;
    private final @Nullable String progress;
    private final boolean empty;
    private boolean logged = false;

    public AntLogMessage(BuildEvent event) {
        String message;
        this.target = event.getTarget() == null ? null : event.getTarget().getName();
        this.task = event.getTask() == null ? null : event.getTask().getTaskName();
        String string = message = event.getMessage() == null ? "" : event.getMessage().trim();
        if (message.startsWith("<?xml")) {
            message = message.substring(message.indexOf(62) + 1).trim();
        }
        this.empty = message.isEmpty();
        MessageType theType = this.toMessageType(event);
        String theProgress = null;
        Matcher m = Pattern.compile("^\b*<progress (.*?)/>").matcher(message);
        if (m.find()) {
            Matcher m1 = Pattern.compile("percent=\"(.*?)\"").matcher(m.group(1));
            Matcher m2 = Pattern.compile("text=\"(.*?)\"").matcher(m.group(1));
            theProgress = m1.find() ? m1.group(1) : null;
            message = m2.find() ? m2.group(1) : "";
            theType = MessageType.INPROGRESS;
        } else if ("echo".equals(this.task) || "echoxml".equals(this.task)) {
            try {
                theProgress = String.valueOf(Integer.parseInt(message));
                theType = MessageType.INPROGRESS;
            }
            catch (NumberFormatException e) {
                theType = MessageType.INFO;
                if ("echo".equals(this.task)) {
                    message = XMLTools.escape(message);
                }
            }
        } else if (!message.startsWith("<")) {
            message = this.task != null && !"progress".equals(this.task) ? XMLTools.escape(this.task + ": " + message) : XMLTools.escape(message);
        }
        this.type = theType;
        this.progress = theProgress;
        this.msg = message.isEmpty() ? null : message;
    }

    public AntLogMessage(MessageType type, @Nullable String message, @Nullable String progress, @Nullable String target, @Nullable String task) {
        this.type = type;
        this.empty = message != null && message.isEmpty();
        this.msg = message == null ? "" : XMLTools.escape(message);
        this.progress = progress;
        this.target = target;
        this.task = task;
    }

    public AntLogMessage(MessageType type, @Nullable String message, @Nullable String progress, @Nullable String target, boolean xml) {
        this.type = type;
        if (message == null) {
            this.empty = true;
            this.msg = "";
        } else {
            this.empty = message.isEmpty();
            this.msg = xml ? message : XMLTools.escape(message);
        }
        this.progress = progress;
        this.target = target;
        this.task = null;
    }

    public AntLogMessage(MessageType type, String message) {
        this(type, message, null, null, false);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setLogged(boolean log) {
        this.logged = log;
    }

    public boolean isType(MessageType t) {
        return this.type != null && this.type == t;
    }

    public @Nullable MessageType getType() {
        return this.type;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("message");
        xml.attribute("logged", this.logged ? "true" : "false");
        if (this.type != null) {
            xml.attribute("type", this.type.toString());
        }
        if (this.target != null) {
            xml.attribute("target", this.target);
        }
        if (this.task != null) {
            xml.attribute("task", this.task);
        }
        if (this.progress != null) {
            xml.attribute("progress", this.progress);
        }
        if (this.msg != null) {
            xml.writeXML(this.msg);
        }
        xml.closeElement();
    }

    public String toString() {
        return "[" + this.task + "]: " + this.msg + " (" + this.target + ")";
    }

    private MessageType toMessageType(BuildEvent event) {
        switch (event.getPriority()) {
            case 0: {
                return MessageType.ERROR;
            }
            case 1: {
                return MessageType.WARN;
            }
            case 4: {
                return MessageType.DEBUG;
            }
        }
        return MessageType.INFO;
    }

    public static enum MessageType {
        TARGETSTART{

            public String toString() {
                return "target-start";
            }

            @Override
            public int getPriority() {
                return 2;
            }
        }
        ,
        TARGETEND{

            public String toString() {
                return "target-end";
            }

            @Override
            public int getPriority() {
                return 2;
            }
        }
        ,
        INFO{

            public String toString() {
                return "info";
            }

            @Override
            public int getPriority() {
                return 2;
            }
        }
        ,
        WARN{

            public String toString() {
                return "warn";
            }

            @Override
            public int getPriority() {
                return 1;
            }
        }
        ,
        DEBUG{

            public String toString() {
                return "debug";
            }

            @Override
            public int getPriority() {
                return 4;
            }
        }
        ,
        INPROGRESS{

            public String toString() {
                return "in-progress";
            }

            @Override
            public int getPriority() {
                return 2;
            }
        }
        ,
        COMPLETE{

            public String toString() {
                return "complete";
            }

            @Override
            public int getPriority() {
                return 2;
            }
        }
        ,
        ERROR{

            public String toString() {
                return "error";
            }

            @Override
            public int getPriority() {
                return 0;
            }
        }
        ,
        FAIL{

            public String toString() {
                return "fail";
            }

            @Override
            public int getPriority() {
                return 0;
            }
        }
        ,
        CANCEL{

            public String toString() {
                return "cancel";
            }

            @Override
            public int getPriority() {
                return 2;
            }
        };


        public abstract int getPriority();
    }
}

