/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.DirectResourceResolver;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolverWrappingURIResolver;
import net.sf.saxon.trans.XPathException;

public class StandardModuleURIResolver
implements ModuleURIResolver {
    Configuration config = null;

    public StandardModuleURIResolver() {
    }

    public StandardModuleURIResolver(Configuration config) {
        this.config = config;
    }

    public void setConfiguration(Configuration config) {
        if (this.config == null) {
            this.config = config;
        }
    }

    @Override
    public StreamSource[] resolve(String moduleURI, String baseURI, String[] locations) throws XPathException {
        StreamSource source;
        if (this.config == null) {
            throw new NullPointerException("No Configuration available in StandardModuleResolver");
        }
        StreamSource streamSource = source = moduleURI != null || baseURI != null ? this.resolveModuleURI(moduleURI, baseURI) : null;
        if (source != null) {
            return new StreamSource[]{source};
        }
        if (locations.length == 0) {
            throw new XPathException("Cannot locate module for namespace " + moduleURI).withErrorCode("XQST0059").asStaticError();
        }
        ArrayList<StreamSource> moduleSources = new ArrayList<StreamSource>();
        for (String hint : locations) {
            StreamSource ss = this.resolveLocationHint(baseURI, hint);
            if (ss == null) continue;
            moduleSources.add(ss);
        }
        return moduleSources.toArray(new StreamSource[0]);
    }

    protected StreamSource resolveModuleURI(String moduleURI, String baseURI) {
        try {
            Source source = null;
            if (this.config != null) {
                ResourceRequest rr = new ResourceRequest();
                rr.uri = moduleURI;
                rr.uriIsNamespace = true;
                rr.baseUri = baseURI;
                rr.nature = "https://www.iana.org/assignments/media-types/application/xquery";
                source = this.config.getResourceResolver().resolve(rr);
            }
            if (source != null) {
                return this.toStreamSource(source);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    private StreamSource toStreamSource(Source src) throws XPathException {
        if (src instanceof AugmentedSource) {
            src = ((AugmentedSource)src).getContainedSource();
        }
        if (src instanceof StreamSource) {
            return (StreamSource)src;
        }
        if (src instanceof SAXSource) {
            return ResourceResolverWrappingURIResolver.convertToStreamSource((SAXSource)src);
        }
        XPathException se = new XPathException("Resource resolver returned non-StreamSource for XQuery module", "XQST0059");
        se.setIsStaticError(true);
        throw se;
    }

    protected StreamSource resolveLocationHint(String baseURI, String locationHint) throws XPathException {
        ResourceRequest rr = new ResourceRequest();
        rr.baseUri = baseURI;
        rr.relativeUri = locationHint;
        rr.nature = "https://www.iana.org/assignments/media-types/application/xquery";
        try {
            rr.uri = ResolveURI.makeAbsolute(rr.relativeUri, baseURI).toString();
            Source src = rr.resolve(this.config.getResourceResolver(), new DirectResourceResolver(this.config));
            return src == null ? null : this.toStreamSource(src);
        }
        catch (URISyntaxException err) {
            throw new XPathException("Cannot resolve relative URI " + rr.relativeUri, err).withErrorCode("XQST0059").asStaticError();
        }
    }
}

