/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ProtocolRestrictor;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DirectResourceResolver
implements ResourceResolver {
    private final Configuration config;

    public DirectResourceResolver(Configuration config) {
        this.config = config;
    }

    @Override
    public Source resolve(ResourceRequest request) throws XPathException {
        InputStream stream;
        if (request.uriIsNamespace) {
            return null;
        }
        ProtocolRestrictor restrictor = this.config.getProtocolRestrictor();
        if (!"all".equals(restrictor.toString())) {
            try {
                URI u = new URI(request.uri);
                if (!restrictor.test(u)) {
                    throw new XPathException("URIs using protocol " + u.getScheme() + " are not permitted");
                }
            }
            catch (URISyntaxException err) {
                throw new XPathException("Unknown URI scheme requested " + request.uri);
            }
        }
        if ("https://www.iana.org/assignments/media-types/application/binary".equals(request.nature)) {
            try {
                String uri = request.baseUri == null ? request.uri : new URI(request.baseUri).resolve(request.uri).toString();
                return ResourceLoader.typedStreamSource(this.config, uri);
            }
            catch (IOException | URISyntaxException e) {
                throw new XPathException("Cannot read " + request.uri, e);
            }
        }
        try {
            stream = ResourceLoader.urlStream(this.config, request.uri);
        }
        catch (IOException e) {
            stream = null;
        }
        if ("https://www.iana.org/assignments/media-types/text/plain".equals(request.nature)) {
            return new StreamSource(stream, request.uri);
        }
        InputSource is = new InputSource(request.uri);
        is.setByteStream(stream);
        XMLReader parser = "http://www.w3.org/1999/XSL/Transform".equals(request.nature) || "http://www.w3.org/2001/XMLSchema".equals(request.nature) ? this.config.getStyleParser() : this.config.getSourceParser();
        Source ss = new SAXSource(parser, is);
        if (stream != null) {
            ss = AugmentedSource.makeAugmentedSource(ss);
            ((AugmentedSource)ss).setPleaseCloseAfterUse(true);
        }
        return ss;
    }
}

