/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.query.compiler.AbstractParser;
import org.datanucleus.query.compiler.Lexer;
import org.datanucleus.query.compiler.Node;
import org.datanucleus.query.compiler.NodeType;
import org.datanucleus.query.compiler.ParameterNode;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class JDOQLParser
extends AbstractParser {
    private static String[] jdoqlMethodNames = new String[]{"contains", "get", "containsKey", "containsValue", "isEmpty", "size", "toLowerCase", "toUpperCase", "indexOf", "matches", "substring", "startsWith", "endsWith", "trim", "length", "getObjectId", "abs", "sqrt", "getDate", "getMonth", "getYear", "getHour", "getMinute", "getSecond", "getDayOfMonth", "getMonthValue", "getDays", "getMonths", "getYears", "ordinal", "toString", "isPresent", "get", "orElse"};
    private boolean explicitParams = false;
    private static String paramPrefixes = ":";
    private boolean allowSingleEquals = false;
    private List<Object> parameterNameList = null;

    @Override
    public void setExplicitParameters(boolean flag) {
        this.explicitParams = flag;
    }

    public void allowSingleEquals(boolean flag) {
        this.allowSingleEquals = flag;
    }

    @Override
    public Node parse(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque();
        Node result = this.processExpression();
        if (this.lexer.ci.getIndex() != this.lexer.ci.getEndIndex()) {
            String unparsed = this.lexer.getInput().substring(this.lexer.ci.getIndex());
            throw new QueryCompilerSyntaxException("Portion of expression could not be parsed: " + unparsed);
        }
        return result;
    }

    @Override
    public Node parseVariable(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque();
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.lexer.getIndex(), this.lexer.getInput());
        }
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.lexer.getIndex(), this.lexer.getInput());
        }
        Node nodeVariable = (Node)this.stack.pop();
        Node nodeType = (Node)this.stack.pop();
        nodeType.appendChildNode(nodeVariable);
        return nodeType;
    }

    @Override
    public Node[] parseFrom(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque();
        return this.processFromExpression();
    }

    private Node[] processFromExpression() {
        this.processExpression();
        Node id = (Node)this.stack.pop();
        StringBuilder className = new StringBuilder(id.getNodeValue().toString());
        while (!id.getChildNodes().isEmpty()) {
            id = id.getFirstChild();
            className.append(".").append(id.getNodeValue().toString());
        }
        String alias = this.lexer.parseIdentifier();
        if (alias != null && alias.equalsIgnoreCase("AS")) {
            alias = this.lexer.parseIdentifier();
        }
        if (alias == null) {
            alias = "this";
        }
        Node classNode = new Node(NodeType.CLASS, className.toString());
        Node aliasNode = new Node(NodeType.NAME, alias);
        classNode.insertChildNode(aliasNode);
        this.stack.push(classNode);
        return new Node[]{classNode};
    }

    @Override
    public Node[] parseUpdate(String expression) {
        return null;
    }

    @Override
    public Node[] parseOrder(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque();
        return this.processOrderExpression();
    }

    @Override
    public Node[] parseResult(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node expr = (Node)this.stack.pop();
            String alias = this.lexer.parseIdentifier();
            if (alias != null && alias.equalsIgnoreCase("AS")) {
                alias = this.lexer.parseIdentifier();
            }
            if (alias != null) {
                Node aliasNode = new Node(NodeType.NAME, alias);
                expr.appendChildNode(aliasNode);
            }
            nodes.add(expr);
        } while (this.lexer.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    @Override
    public Node[] parseTuple(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, true);
        this.stack = new ArrayDeque();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node expr = (Node)this.stack.pop();
            nodes.add(expr);
        } while (this.lexer.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    @Override
    public Node[][] parseVariables(String expression) {
        this.lexer = new Lexer(expression, paramPrefixes, true);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        while (!StringUtils.isWhitespace(this.lexer.remaining())) {
            this.processPrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("Parsing variable list and expected variable type", this.lexer.getIndex(), this.lexer.getInput());
            }
            if (!this.processIdentifier()) {
                throw new QueryCompilerSyntaxException("Parsing variable list and expected variable name", this.lexer.getIndex(), this.lexer.getInput());
            }
            Node nodeVariable = (Node)this.stack.pop();
            String varName = (String)nodeVariable.getNodeValue();
            if (!JDOQLQueryHelper.isValidJavaIdentifierForJDOQL(varName)) {
                throw new NucleusUserException(Localiser.msg("021105", varName));
            }
            Node nodeType = (Node)this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
            if (this.lexer.parseString(";")) continue;
        }
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    @Override
    public Node[][] parseParameters(String expression) {
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        StringTokenizer tokeniser = new StringTokenizer(expression, ",");
        while (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken();
            StringTokenizer subTokeniser = new StringTokenizer(token, " ");
            if (subTokeniser.countTokens() != 2) {
                throw new QueryCompilerSyntaxException(Localiser.msg("021101", expression));
            }
            String classDecl = subTokeniser.nextToken();
            String parameterName = subTokeniser.nextToken();
            Node declNode = new Node(NodeType.IDENTIFIER, classDecl);
            Node nameNode = new Node(NodeType.IDENTIFIER, parameterName);
            nodes.add(new Node[]{declNode, nameNode});
        }
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    private Node[] processOrderExpression() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node directionNode = null;
            directionNode = this.lexer.parseString("ascending") || this.lexer.parseString("asc") || this.lexer.parseString("ASCENDING") || this.lexer.parseString("ASC") ? new Node(NodeType.OPERATOR, "ascending") : (this.lexer.parseString("descending") || this.lexer.parseString("desc") || this.lexer.parseString("DESCENDING") || this.lexer.parseString("DESC") ? new Node(NodeType.OPERATOR, "descending") : new Node(NodeType.OPERATOR, "ascending"));
            Node nullsNode = null;
            if (this.lexer.parseString("NULLS FIRST") || this.lexer.parseString("nulls first")) {
                nullsNode = new Node(NodeType.OPERATOR, "nulls first");
            } else if (this.lexer.parseString("NULLS LAST") || this.lexer.parseString("nulls last")) {
                nullsNode = new Node(NodeType.OPERATOR, "nulls last");
            }
            Node expr = new Node(NodeType.OPERATOR, "order");
            expr.insertChildNode(directionNode);
            if (nullsNode != null) {
                expr.appendChildNode(nullsNode);
            }
            if (!this.stack.isEmpty()) {
                expr.insertChildNode((Node)this.stack.pop());
            }
            nodes.add(expr);
        } while (this.lexer.parseChar(','));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node processExpression() {
        this.processConditionalOrExpression();
        return (Node)this.stack.peek();
    }

    private void processConditionalOrExpression() {
        this.processConditionalAndExpression();
        while (this.lexer.parseString("||")) {
            this.processConditionalAndExpression();
            Node expr = new Node(NodeType.OPERATOR, "||");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processConditionalAndExpression() {
        this.processInclusiveOrExpression();
        while (this.lexer.parseString("&&")) {
            this.processInclusiveOrExpression();
            Node expr = new Node(NodeType.OPERATOR, "&&");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processInclusiveOrExpression() {
        this.processExclusiveOrExpression();
        while (this.lexer.parseChar('|', '|')) {
            this.processExclusiveOrExpression();
            Node expr = new Node(NodeType.OPERATOR, "|");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processExclusiveOrExpression() {
        this.processAndExpression();
        while (this.lexer.parseChar('^')) {
            this.processAndExpression();
            Node expr = new Node(NodeType.OPERATOR, "^");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processAndExpression() {
        this.processRelationalExpression();
        while (this.lexer.parseChar('&', '&')) {
            this.processRelationalExpression();
            Node expr = new Node(NodeType.OPERATOR, "&");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processRelationalExpression() {
        this.processAdditiveExpression();
        while (true) {
            Node expr;
            if (this.lexer.parseString("==")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "==");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.lexer.parseString("!=")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "!=");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.lexer.parseString("=")) {
                if (this.allowSingleEquals) {
                    this.processAdditiveExpression();
                    expr = new Node(NodeType.OPERATOR, "==");
                    expr.insertChildNode((Node)this.stack.pop());
                    expr.insertChildNode((Node)this.stack.pop());
                    this.stack.push(expr);
                    continue;
                }
                throw new QueryCompilerSyntaxException("Invalid operator \"=\". Did you mean to use \"==\"?");
            }
            if (this.lexer.parseString("<=")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "<=");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.lexer.parseString(">=")) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, ">=");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.lexer.parseChar('<')) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, "<");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.lexer.parseChar('>')) {
                this.processAdditiveExpression();
                expr = new Node(NodeType.OPERATOR, ">");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.lexer.parseString("instanceof")) break;
            this.processAdditiveExpression();
            expr = new Node(NodeType.OPERATOR, "instanceof");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processAdditiveExpression() {
        this.processMultiplicativeExpression();
        while (true) {
            Node expr;
            if (this.lexer.parseChar('+')) {
                this.processMultiplicativeExpression();
                expr = new Node(NodeType.OPERATOR, "+");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.lexer.parseChar('-')) break;
            this.processMultiplicativeExpression();
            expr = new Node(NodeType.OPERATOR, "-");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processMultiplicativeExpression() {
        this.processUnaryExpression();
        while (true) {
            Node expr;
            if (this.lexer.parseChar('*')) {
                this.processUnaryExpression();
                expr = new Node(NodeType.OPERATOR, "*");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.lexer.parseChar('/')) {
                this.processUnaryExpression();
                expr = new Node(NodeType.OPERATOR, "/");
                expr.insertChildNode((Node)this.stack.pop());
                expr.insertChildNode((Node)this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.lexer.parseChar('%')) break;
            this.processUnaryExpression();
            expr = new Node(NodeType.OPERATOR, "%");
            expr.insertChildNode((Node)this.stack.pop());
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processUnaryExpression() {
        if (this.lexer.parseString("++")) {
            throw new QueryCompilerSyntaxException("Unsupported operator '++'");
        }
        if (this.lexer.parseString("--")) {
            throw new QueryCompilerSyntaxException("Unsupported operator '--'");
        }
        if (this.lexer.parseChar('+')) {
            this.processUnaryExpression();
        } else if (this.lexer.parseChar('-')) {
            this.processUnaryExpression();
            Node expr = new Node(NodeType.OPERATOR, "-");
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        } else if (this.lexer.parseChar('~')) {
            this.processUnaryExpression();
            Node expr = new Node(NodeType.OPERATOR, "~");
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        } else if (this.lexer.parseChar('!')) {
            this.processUnaryExpression();
            Node expr = new Node(NodeType.OPERATOR, "!");
            expr.insertChildNode((Node)this.stack.pop());
            this.stack.push(expr);
        } else {
            this.processPrimary();
        }
    }

    protected void processPrimary() {
        if (this.lexer.parseString("DISTINCT ") || this.lexer.parseString("distinct")) {
            Node distinctNode = new Node(NodeType.OPERATOR, "DISTINCT");
            this.processExpression();
            Node identifierNode = (Node)this.stack.pop();
            distinctNode.appendChildNode(identifierNode);
            this.stack.push(distinctNode);
            return;
        }
        Node castNode = null;
        if (this.processCast()) {
            castNode = (Node)this.stack.pop();
        }
        if (this.lexer.peekString("IF(") || this.lexer.peekString("if(") || this.lexer.peekString("IF (") || this.lexer.peekString("if (")) {
            this.processIfElseExpression();
            return;
        }
        if (this.processCreator()) {
            boolean endOfChain = false;
            while (!endOfChain) {
                if (this.lexer.parseChar('.')) {
                    if (!this.processMethod()) continue;
                    Node invokeNode = (Node)this.stack.pop();
                    Node invokedNode = (Node)this.stack.peek();
                    invokedNode.appendChildNode(invokeNode);
                    continue;
                }
                endOfChain = true;
            }
            if (castNode != null) {
                throw new NucleusException("Dont currently support compile of cast of creator expression");
            }
            return;
        }
        if (this.processLiteral()) {
            boolean endOfChain = false;
            while (!endOfChain) {
                if (this.lexer.parseChar('.')) {
                    if (!this.processMethod()) continue;
                    Node invokeNode = (Node)this.stack.pop();
                    Node invokedNode = (Node)this.stack.peek();
                    invokedNode.appendChildNode(invokeNode);
                    continue;
                }
                endOfChain = true;
            }
            if (castNode != null) {
                throw new NucleusException("Dont currently support compile of cast of literal expression");
            }
            return;
        }
        if (this.processMethod()) {
            if (castNode != null) {
                throw new NucleusException("Dont currently support compile of cast of static method call");
            }
            return;
        }
        if (this.processArray()) {
            boolean endOfChain = false;
            while (!endOfChain) {
                if (this.lexer.parseChar('.')) {
                    if (!this.processMethod()) continue;
                    Node invokeNode = (Node)this.stack.pop();
                    Node invokedNode = (Node)this.stack.peek();
                    invokedNode.appendChildNode(invokeNode);
                    continue;
                }
                endOfChain = true;
            }
            if (castNode != null) {
                throw new NucleusException("Dont currently support compile of cast of array expression");
            }
            return;
        }
        int sizeBeforeBraceProcessing = this.stack.size();
        boolean braceProcessing = false;
        if (this.lexer.parseChar('(')) {
            this.processExpression();
            if (!this.lexer.parseChar(')')) {
                throw new QueryCompilerSyntaxException("expected ')'", this.lexer.getIndex(), this.lexer.getInput());
            }
            if (!this.lexer.parseChar('.')) {
                return;
            }
            braceProcessing = true;
        }
        if (!this.processMethod() && !this.processIdentifier()) {
            if (castNode != null) {
                throw new QueryCompilerSyntaxException("Found CAST expression with nothing after", this.lexer.getIndex(), this.lexer.getInput());
            }
            throw new QueryCompilerSyntaxException("Method/Identifier expected", this.lexer.getIndex(), this.lexer.getInput());
        }
        int size = this.stack.size();
        if (braceProcessing) {
            size = sizeBeforeBraceProcessing + 1;
        }
        while (this.lexer.parseChar('.')) {
            if (this.processMethod() || this.processIdentifier()) continue;
            throw new QueryCompilerSyntaxException("Identifier expected", this.lexer.getIndex(), this.lexer.getInput());
        }
        if (castNode != null) {
            ((Node)this.stack.peek()).appendChildNode(castNode);
        }
        while (this.stack.size() > size) {
            Node top = (Node)this.stack.pop();
            Node peek = (Node)this.stack.peek();
            Node lastDescendant = JDOQLParser.getLastDescendantNodeForNode(peek);
            if (lastDescendant != null) {
                lastDescendant.appendChildNode(top);
                continue;
            }
            Node primNode = new Node(NodeType.PRIMARY);
            primNode.appendChildNode(peek);
            primNode.appendChildNode(top);
            this.stack.pop();
            this.stack.push(primNode);
        }
    }

    private void processIfElseExpression() {
        Node caseNode = new Node(NodeType.CASE);
        if (!this.lexer.parseString("IF") || this.lexer.parseString("if")) {
            throw new QueryCompilerSyntaxException("Expected IF or if", this.lexer.getIndex(), this.lexer.getInput());
        }
        if (!this.lexer.parseChar('(')) {
            throw new QueryCompilerSyntaxException("Expected '(' as part of IF (...)", this.lexer.getIndex(), this.lexer.getInput());
        }
        this.processExpression();
        Node whenNode = (Node)this.stack.pop();
        caseNode.appendChildNode(whenNode);
        if (!this.lexer.parseChar(')')) {
            throw new QueryCompilerSyntaxException("Expected ')' as part of IF (...)", this.lexer.getIndex(), this.lexer.getInput());
        }
        this.processExpression();
        Node actionNode = (Node)this.stack.pop();
        caseNode.appendChildNode(actionNode);
        boolean elseClause = false;
        while (this.lexer.parseString("ELSE") || this.lexer.parseString("else")) {
            boolean hasIf = false;
            if (this.lexer.parseString("IF") || this.lexer.parseString("if")) {
                hasIf = true;
                if (!this.lexer.parseChar('(')) {
                    throw new QueryCompilerSyntaxException("Expected '(' as part of IF (...)", this.lexer.getIndex(), this.lexer.getInput());
                }
                this.processExpression();
                whenNode = (Node)this.stack.pop();
                caseNode.appendChildNode(whenNode);
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("Expected ')' as part of IF (...)", this.lexer.getIndex(), this.lexer.getInput());
                }
            }
            this.processExpression();
            actionNode = (Node)this.stack.pop();
            caseNode.appendChildNode(actionNode);
            if (hasIf) continue;
            elseClause = true;
        }
        if (!elseClause) {
            throw new QueryCompilerSyntaxException("Use of IF {expr} ELSE IF {expr} structure should always terminate with ELSE {expr} but doesn't", this.lexer.getIndex(), this.lexer.getInput());
        }
        this.stack.push(caseNode);
    }

    private boolean processCast() {
        int idx = this.lexer.getIndex();
        String typeName = this.lexer.parseCast();
        if (typeName == null) {
            return false;
        }
        if (this.lexer.remaining().isEmpty()) {
            this.lexer.setIndex(idx);
            return false;
        }
        Node castNode = new Node(NodeType.CAST, typeName);
        this.stack.push(castNode);
        return true;
    }

    private boolean processCreator() {
        if (this.lexer.parseString("new ")) {
            int size = this.stack.size();
            if (!this.processMethod()) {
                if (!this.processIdentifier()) {
                    throw new QueryCompilerSyntaxException("Identifier expected", this.lexer.getIndex(), this.lexer.getInput());
                }
                while (this.lexer.parseChar('.')) {
                    if (this.processMethod() || this.processIdentifier()) continue;
                    throw new QueryCompilerSyntaxException("Identifier expected", this.lexer.getIndex(), this.lexer.getInput());
                }
            }
            while (this.stack.size() - 1 > size) {
                Node top = (Node)this.stack.pop();
                Node peek = (Node)this.stack.peek();
                peek.insertChildNode(top);
            }
            Node expr = (Node)this.stack.pop();
            Node newExpr = new Node(NodeType.CREATOR);
            newExpr.insertChildNode(expr);
            this.stack.push(newExpr);
            return true;
        }
        return false;
    }

    private boolean processMethod() {
        String method = this.lexer.parseMethod();
        if (method != null) {
            this.lexer.skipWS();
            this.lexer.parseChar('(');
            if (this.strict && Arrays.binarySearch(jdoqlMethodNames, method) < 0) {
                throw new QueryCompilerSyntaxException("Query uses method \"" + method + "\" but this is not a standard JDOQL method name");
            }
            Node expr = new Node(NodeType.INVOKE, method);
            if (!this.lexer.parseChar(')')) {
                do {
                    this.processExpression();
                    expr.addProperty((Node)this.stack.pop());
                } while (this.lexer.parseChar(','));
                if (!this.lexer.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.lexer.getIndex(), this.lexer.getInput());
                }
            }
            this.stack.push(expr);
            return true;
        }
        return false;
    }

    private boolean processArray() {
        if (this.lexer.parseChar('{')) {
            ArrayList<Node> elements = new ArrayList<Node>();
            while (!this.lexer.parseChar('}')) {
                this.processPrimary();
                Node elementNode = (Node)this.stack.pop();
                elements.add(elementNode);
                if (this.lexer.parseChar('}')) break;
                if (this.lexer.parseChar(',')) continue;
                throw new QueryCompilerSyntaxException("',' or '}' expected", this.lexer.getIndex(), this.lexer.getInput());
            }
            Node arrayNode = new Node(NodeType.ARRAY, elements);
            this.stack.push(arrayNode);
            if (this.lexer.parseString(".length")) {
                Node lengthMethod = new Node(NodeType.INVOKE, "length");
                arrayNode.appendChildNode(lengthMethod);
            }
            return true;
        }
        return false;
    }

    protected boolean processLiteral() {
        Object litValue = null;
        boolean single_quote_next = this.lexer.nextIsSingleQuote();
        String sLiteral = this.lexer.parseStringLiteral();
        if (sLiteral != null) {
            litValue = sLiteral.length() == 1 && single_quote_next ? Character.valueOf(sLiteral.charAt(0)) : sLiteral;
        } else {
            Number fLiteral = this.lexer.parseFloatingPointLiteral();
            if (fLiteral != null) {
                litValue = fLiteral;
            } else {
                Number iLiteral = this.lexer.parseIntegerLiteral();
                if (iLiteral != null) {
                    litValue = iLiteral;
                } else {
                    Boolean bLiteral = this.lexer.parseBooleanLiteral();
                    if (bLiteral != null) {
                        litValue = bLiteral;
                    } else if (!this.lexer.parseNullLiteral()) {
                        return false;
                    }
                }
            }
        }
        this.stack.push(new Node(NodeType.LITERAL, litValue));
        return true;
    }

    private boolean processIdentifier() {
        String id = this.lexer.parseIdentifier();
        if (id == null) {
            return false;
        }
        char first = id.charAt(0);
        if (first == ':') {
            if (this.explicitParams) {
                throw new QueryCompilerSyntaxException("Explicit parameters defined for query, yet implicit parameter syntax (\"" + id + "\") found");
            }
            String name = id.substring(1);
            ParameterNode expr = new ParameterNode(NodeType.PARAMETER, name, this.getPositionFromParameterName(name));
            this.stack.push(expr);
            return true;
        }
        Node expr = new Node(NodeType.IDENTIFIER, id);
        this.stack.push(expr);
        return true;
    }

    private int getPositionFromParameterName(Object name) {
        int pos;
        if (this.parameterNameList == null) {
            this.parameterNameList = new ArrayList<Object>(1);
        }
        if ((pos = this.parameterNameList.indexOf(name)) == -1) {
            pos = this.parameterNameList.size();
            this.parameterNameList.add(name);
        }
        return pos;
    }
}

