/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.utils.XMLParserErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XMLUtils {
    private XMLUtils() {
    }

    public static SAXParserFactory safeSAXParserFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return factory;
    }

    public static @Nullable String escape(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.indexOf(38) == -1 && s.indexOf(60) == -1) {
            return s;
        }
        StringBuilder valid = new StringBuilder(s);
        int shift = 0;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '&': {
                    valid.insert(i + shift + 1, "amp;");
                    shift += 4;
                    continue block4;
                }
                case '<': {
                    valid.deleteCharAt(i + shift);
                    valid.insert(i + shift, "&lt;");
                    shift += 3;
                    continue block4;
                }
            }
        }
        return valid.toString();
    }

    public static @Nullable String escapeForAttribute(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.indexOf(38) == -1 && s.indexOf(60) == -1 && s.indexOf(34) == -1) {
            return s;
        }
        StringBuilder valid = new StringBuilder(s);
        int shift = 0;
        block6: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '&': {
                    valid.insert(i + shift + 1, "amp;");
                    shift += 4;
                    continue block6;
                }
                case '\"': {
                    valid.deleteCharAt(i + shift);
                    valid.insert(i + shift, "&quot;");
                    shift += 5;
                    continue block6;
                }
                case '\'': {
                    valid.deleteCharAt(i + shift);
                    valid.insert(i + shift, "&apos;");
                    shift += 5;
                    continue block6;
                }
                case '<': {
                    valid.deleteCharAt(i + shift);
                    valid.insert(i + shift, "&lt;");
                    shift += 3;
                    continue block6;
                }
            }
        }
        return valid.toString();
    }

    public static void parse(InputStream in, ContentHandler handler) throws PageseederException {
        XMLUtils.parse(in, handler, null, null);
    }

    public static void parse(InputStream in, ContentHandler handler, @Nullable List<String> errors, @Nullable List<String> warnings) throws PageseederException {
        try {
            SAXParserFactory factory = XMLUtils.safeSAXParserFactory();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setContentHandler(handler);
            XMLParserErrorHandler errorHandler = new XMLParserErrorHandler();
            reader.setErrorHandler(errorHandler);
            try (InputStream inputStream = in;){
                reader.parse(new InputSource(in));
            }
            if (errors != null) {
                errors.addAll(errorHandler.getErrors());
            } else if (errorHandler.hasErrors()) {
                StringBuilder all = new StringBuilder();
                for (String e : errorHandler.getErrors()) {
                    all.append(e).append("\n");
                }
                throw new PageseederException(all.toString());
            }
            if (warnings != null) {
                warnings.addAll(errorHandler.getWarnings());
            }
        }
        catch (IOException ex) {
            throw new PageseederException("Failed to read/write PS Standard XML", ex);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new PageseederException(ex.getMessage(), ex);
        }
    }
}

