/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static File descendantFile(File base, String path) throws IOException {
        File descendant = new File(base, path);
        if (!descendant.getCanonicalPath().startsWith(base.getCanonicalPath())) {
            LOGGER.error("Path results in a file outside base folder: {}", (Object)path);
            throw new IOException("Path results in a file outside base folder");
        }
        return descendant;
    }

    public static String getUrlParamSeparator(@Nullable String url) {
        if (url == null) {
            return "";
        }
        if (url.indexOf(63) == -1) {
            return "?";
        }
        if (url.endsWith("?") || url.endsWith("&")) {
            return "";
        }
        return "&";
    }

    public static @Nullable String removePasswordJsessionid(@Nullable String message) {
        int j;
        if (message == null) {
            return null;
        }
        Object msg = message;
        int i = ((String)msg).indexOf("password=");
        if (i != -1) {
            j = ((String)msg).indexOf("&", i);
            msg = j != -1 ? ((String)msg).substring(0, i) + "{password removed}" + ((String)msg).substring(j) : ((String)msg).substring(0, i) + "{password removed}";
        }
        if ((i = ((String)msg).indexOf("jsessionid=")) != -1) {
            j = ((String)msg).indexOf("?", i);
            msg = j != -1 ? ((String)msg).substring(0, i) + "{jsessionid removed}" + ((String)msg).substring(j) : ((String)msg).substring(0, i) + "{jsessionid removed}";
        }
        return msg;
    }

    public static @Nullable String computeRelativePath(File file, File root) {
        String rpath;
        String fpath;
        try {
            fpath = file.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to compute file's canonical path: " + ex.getMessage(), ex);
        }
        try {
            rpath = root.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to compute root's canonical path: " + ex.getMessage(), ex);
        }
        if (fpath.equals(rpath)) {
            return "";
        }
        if (fpath.startsWith(rpath + File.separator)) {
            return fpath.substring(rpath.length() + 1).replace(File.separatorChar, '/');
        }
        return null;
    }
}

