/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.Upload;
import com.pageseeder.publishapi.ant.AntLogger;
import com.pageseeder.publishapi.ant.Notification;
import com.pageseeder.publishapi.ant.Workflow;
import com.pageseeder.publishapi.utils.ANTUtils;
import com.pageseeder.publishapi.utils.ThreadLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;

public class UploadTask
extends Task {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private @Nullable String group;
    private @Nullable Notification notification = null;
    private @Nullable Workflow workflow;
    private @Nullable String folder;
    private @Nullable String doclabels;
    private boolean unzip = false;
    private boolean resolve = true;
    private boolean validate = true;
    private boolean failOnError = true;
    private boolean deleteZip = true;
    private boolean overwrite = false;
    private boolean overwriteProperties = false;
    private boolean index = true;
    private boolean docidIsFilename = false;
    private @Nullable String saveuris;
    private long pollinginterval = 5000L;
    private String config = "default";

    public void setConfig(String config) {
        this.config = config;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setFolder(@Nullable String f) {
        f = f != null && f.startsWith("/") ? f.substring(1) : f;
        this.folder = f = f != null && f.endsWith("/") ? f.substring(0, f.length() - 1) : f;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Notification createNotification() {
        this.notification = new Notification();
        return this.notification;
    }

    public void setIndex(boolean index) {
        this.index = index;
    }

    public void setUnzip(boolean unzip) {
        this.unzip = unzip;
    }

    public void setDeleteZip(boolean deleteZip) {
        this.deleteZip = deleteZip;
    }

    public void setDocidIsFilename(boolean docidIsFilename) {
        this.docidIsFilename = docidIsFilename;
    }

    public void setResolve(boolean resolve) {
        this.resolve = resolve;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setValidate(boolean val) {
        this.validate = val;
    }

    public void setOverwriteProperties(boolean overwriteProperties) {
        this.overwriteProperties = overwriteProperties;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public Workflow createWorkflow() {
        this.workflow = new Workflow();
        return this.workflow;
    }

    public void setSaveURIs(String uris) {
        this.saveuris = uris;
    }

    public void setDocLabels(String dlabels) {
        this.doclabels = dlabels;
    }

    public void setPollinginterval(long ms) {
        this.pollinginterval = ms;
    }

    public void execute() throws BuildException {
        block19: {
            if (this.filesets.isEmpty()) {
                throw new BuildException("No target directory/files is specfified. Please specify the embedded '<fileset>' argument.");
            }
            if (this.group == null) {
                throw new BuildException("Please specify a group name.");
            }
            AntUploadLogger logger = new AntUploadLogger(this);
            try {
                HashMap<String, File> toUpload = new HashMap<String, File>();
                for (FileSet fs : this.filesets) {
                    String[] filenames;
                    DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                    File dir = fs.getDir(this.getProject());
                    for (String filename : filenames = ds.getIncludedFiles()) {
                        File f = new File(dir, filename);
                        if (!f.exists()) continue;
                        if (toUpload.containsKey(f.getName())) {
                            this.log("The file " + f.getAbsolutePath() + " is ignored as there is already a file with this name: " + ((File)toUpload.get(f.getName())).getAbsolutePath());
                            continue;
                        }
                        toUpload.put(f.getName(), f);
                    }
                }
                if (toUpload.isEmpty()) {
                    throw new BuildException("No files to upload");
                }
                Upload up = new Upload(ANTUtils.buildConfig(this.getProject(), this.config), this.group, this.folder);
                up.setNotification(this.notification);
                up.setWorkflow(this.workflow);
                up.setUploadDetails(this.overwrite, this.overwriteProperties, this.resolve, this.validate, this.index, this.unzip, this.deleteZip);
                up.setPollingInterval(this.pollinginterval);
                up.setUploadLogger(logger);
                up.setLoadCreatedURIs(this.saveuris != null);
                StringBuilder filesUploaded = new StringBuilder();
                for (File f : toUpload.values()) {
                    up.addFile(f, "UTF-8", f.getName(), null, this.docidIsFilename ? "[filename]" : null, this.doclabels == null ? null : this.doclabels.split(","));
                    if (filesUploaded.length() > 0) {
                        filesUploaded.append(", ");
                    }
                    filesUploaded.append(f.getName());
                }
                this.log("The following files have been sent: " + String.valueOf(filesUploaded));
                String response = up.getResponse();
                if (this.saveuris == null) break block19;
                try (FileOutputStream fout = new FileOutputStream(this.saveuris);){
                    fout.write(response.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception ex) {
                if (logger.getThreadID() != null) {
                    Logger log = AntLogger.newInstance(this);
                    String msg = "<threadid group=\"" + this.group + "\">" + logger.getThreadID() + "</threadid>";
                    if (this.failOnError) {
                        log.error(msg);
                    } else {
                        log.warn(msg);
                    }
                }
                if (this.failOnError) {
                    this.log("Failed to upload: " + ex.getMessage(), 0);
                    throw new BuildException("Error executing Upload: " + ex.getMessage(), (Throwable)ex);
                }
                this.log("Failed to upload: " + ex.getMessage(), 1);
            }
        }
    }

    private static class AntUploadLogger
    implements ThreadLogger {
        private final UploadTask task;
        private @Nullable String threadID = null;

        public AntUploadLogger(UploadTask t) {
            this.task = t;
        }

        @Override
        public void addStatus(ThreadLogger.Status status, String msg) {
            int level;
            if (status == ThreadLogger.Status.WARNING) {
                level = 1;
            } else if (status == ThreadLogger.Status.COMPLETED) {
                level = 2;
            } else if (status == ThreadLogger.Status.CANCELLED) {
                level = 1;
            } else if (status == ThreadLogger.Status.FAILED) {
                level = 0;
            } else if (status == ThreadLogger.Status.ERROR) {
                level = 0;
            } else {
                return;
            }
            if (this.task.failOnError && level == 0) {
                throw new BuildException(msg);
            }
            this.task.log(msg, level);
        }

        @Override
        public void complete() {
        }

        @Override
        public @Nullable String getFinalResponse() {
            return null;
        }

        @Override
        public void setThreadID(String threadid) {
            this.threadID = threadid;
        }

        @Override
        public @Nullable String getThreadID() {
            return this.threadID;
        }
    }
}

