/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ant.AntLogger;
import com.pageseeder.publishapi.ant.TransformFiles;
import com.pageseeder.publishapi.process.config.Param;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.config.IncludeExclude;
import org.pageseeder.psml.process.config.XSLTTransformation;
import org.pageseeder.psml.process.util.Files;
import org.pageseeder.psml.process.util.XSLTTransformer;
import org.slf4j.Logger;

public final class TransformTask
extends Task {
    private @Nullable String src = null;
    private @Nullable String dest = null;
    private @Nullable String xsl = null;
    private boolean moveall = false;
    private @Nullable TransformFiles filesFilter = null;
    private final Collection<Param> params = new ArrayList<Param>();

    public void setSrc(String source) {
        this.src = source;
    }

    public void setDest(String destination) {
        this.dest = destination;
    }

    public void setXSLT(String xslt) {
        this.xsl = xslt;
    }

    public void setMoveAll(boolean moveall) {
        this.moveall = moveall;
    }

    public Param createParam() {
        Param param = new Param();
        this.params.add(param);
        return param;
    }

    public TransformFiles createFiles() {
        this.filesFilter = new TransformFiles();
        return this.filesFilter;
    }

    public void execute() throws BuildException {
        File destFolder;
        File source = this.checkSrc();
        File xslt = this.checkXSLT();
        if (this.dest == null) {
            throw new BuildException("Dest must be specified");
        }
        File destination = new File(this.dest);
        File file = destFolder = source.isDirectory() ? destination : destination.getParentFile();
        if (!destFolder.exists()) {
            destFolder.mkdirs();
        }
        if (!destFolder.exists()) {
            throw new BuildException("Failed to create destination folder " + destFolder.getAbsolutePath());
        }
        if (!destFolder.isDirectory()) {
            throw new BuildException("Invalid destination folder " + destFolder.getAbsolutePath());
        }
        XSLTTransformation transform = new XSLTTransformation();
        transform.setXSLT(xslt.getAbsolutePath());
        if (this.filesFilter != null) {
            transform.addIncludes((Collection)this.filesFilter.getIncludes());
            transform.addExcludes((Collection)this.filesFilter.getExcludes());
            for (IncludeExclude ie : this.filesFilter.getIncludeExcludes()) {
                transform.addIncludeExclude(ie);
            }
        }
        for (Param p : this.params) {
            transform.setParam(p.getName(), p.getValue());
        }
        Logger logger = AntLogger.newInstance(this);
        logger.debug("Collecting file(s) from {}", (Object)source.getAbsolutePath());
        HashMap<String, File> files = new HashMap<String, File>();
        if (!source.isDirectory()) {
            files.put(destination.getName(), source);
        } else {
            this.collectAll(source, files);
        }
        logger.info("Running transform with {}", (Object)this.xsl);
        try {
            XSLTTransformer transformer = new XSLTTransformer(transform);
            transformer.setLog(logger);
            transformer.setValidate(false);
            transformer.setPreserveSrc(false);
            transformer.setMoveAll(this.moveall);
            transformer.transform(files, destFolder);
        }
        catch (ProcessException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void collectAll(File file, Map<String, File> files) {
        this.collectFiles(file, file, files);
    }

    private void collectFiles(File file, File root, Map<String, File> files) {
        if (file.isDirectory()) {
            File[] all = file.listFiles();
            if (all != null) {
                for (File f : all) {
                    this.collectFiles(f, root, files);
                }
            }
        } else if (file.isFile()) {
            files.put(Files.computeRelativePath((File)file, (File)root), file);
        }
    }

    private File checkSrc() throws BuildException {
        if (this.src == null) {
            throw new BuildException("Src must be specified");
        }
        File source = new File(this.src);
        if (!source.exists()) {
            source = new File(this.getProject().getBaseDir(), this.src);
        }
        if (!source.exists()) {
            throw new BuildException("Invalid src location " + this.src);
        }
        return source;
    }

    private File checkXSLT() throws BuildException {
        if (this.xsl == null) {
            throw new BuildException("Xslt must be specified");
        }
        File xslt = new File(this.xsl);
        if (!xslt.exists()) {
            xslt = new File(this.getProject().getBaseDir(), this.xsl);
        }
        if (!xslt.exists()) {
            throw new BuildException("Invalid xslt location " + this.xsl);
        }
        return xslt;
    }
}

