/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ant.AntLogger;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.split.PSMLSplitter;

public final class SplitTask
extends Task {
    private @Nullable String src = null;
    private @Nullable String dest = null;
    private @Nullable String config = null;
    private @Nullable String media = null;
    private @Nullable String work = null;

    public void setSrc(String source) {
        this.src = source;
    }

    public void setDest(String destination) {
        this.dest = destination;
    }

    public void setConfig(String configuration) {
        this.config = configuration;
    }

    public void setMediafolder(String mediafolder) {
        this.media = mediafolder;
    }

    public void setWorking(String working) {
        this.work = working;
    }

    public void execute() throws BuildException {
        if (this.src == null) {
            throw new BuildException("Src must be specified");
        }
        File source = new File(this.src);
        if (!source.exists()) {
            source = new File(this.getProject().getBaseDir(), this.src);
        }
        if (!source.exists()) {
            throw new BuildException("Invalid src location " + this.src);
        }
        if (this.dest == null) {
            throw new BuildException("Dest must be specified");
        }
        File destination = new File(this.dest);
        if (this.config == null) {
            throw new BuildException("Config must be specified");
        }
        File configuration = new File(this.config);
        if (!configuration.exists()) {
            configuration = new File(this.getProject().getBaseDir(), this.config);
        }
        if (!configuration.exists()) {
            throw new BuildException("Invalid config location " + this.config);
        }
        PSMLSplitter.Builder b = new PSMLSplitter.Builder();
        b.source(source);
        b.destination(destination);
        b.config(configuration);
        b.media(this.media);
        if (this.work != null) {
            b.working(new File(this.work));
        }
        b.log(AntLogger.newInstance(this));
        try {
            PSMLSplitter s = b.build();
            s.process();
        }
        catch (IOException ex) {
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
    }
}

