/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.ant.Parameter;
import com.pageseeder.publishapi.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.annotation.Nullable;

public abstract class PageseederTask
extends Task {
    private @Nullable ExternalConfig config = null;
    private @Nullable String propertiesFile = null;
    private @Nullable String host = null;
    private String port = "80";
    private String sitePrefix = "/ps";
    private String servletPrefix = "/servlet";
    private @Nullable String jsessionid = null;
    private @Nullable String username = null;
    private @Nullable String password = null;
    private final List<Parameter> parameters = new ArrayList<Parameter>();

    public Parameter createParameter() {
        Parameter param = new Parameter();
        this.parameters.add(param);
        return param;
    }

    public void setHost(String h) {
        this.host = h;
    }

    public void setPort(String p) {
        this.port = p;
    }

    public void setUsername(String u) {
        this.username = u;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public void setSitePrefix(String prefix) {
        this.sitePrefix = prefix;
    }

    public void setServletPrefix(String prefix) {
        this.servletPrefix = prefix;
    }

    public void setJsessionId(String sessionId) {
        this.jsessionid = sessionId;
    }

    public void setPropertiesfile(String f) {
        this.propertiesFile = new File(f).exists() ? f : (new File(this.getProject().getBaseDir(), f).exists() ? new File(this.getProject().getBaseDir(), f).getAbsolutePath() : f);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public ExternalConfig getExternalConfig() throws PageseederException {
        if (this.config != null) {
            return this.config;
        }
        if (this.propertiesFile == null && this.host == null) {
            throw new PageseederException("Please specify a properties file to use or the host to connect to.");
        }
        if (this.propertiesFile == null && this.jsessionid == null && this.username == null) {
            throw new PageseederException("Please specify a properties file to use or a jsessionid or a username to authenticate.");
        }
        if (this.propertiesFile == null) {
            this.config = new ExternalConfig();
            this.config.setHost(this.host);
            if (this.port != null) {
                this.config.setPort(this.port);
            }
            if (this.servletPrefix != null) {
                this.config.setServletPrefix(this.servletPrefix);
            }
            if (this.sitePrefix != null) {
                this.config.setPSPrefix(this.sitePrefix);
            }
            if (this.username != null) {
                this.config.setUsername(this.username);
            }
            if (this.password != null) {
                this.config.setPassword(this.password);
            }
        } else {
            this.config = new ExternalConfig();
            this.config.loadFromFile(this.propertiesFile);
        }
        if (this.jsessionid != null) {
            this.config.setJSessionID(this.jsessionid);
        }
        return this.config;
    }

    public @Nullable String getJsessionid() {
        return this.jsessionid;
    }

    public void log(String msg, int msgLevel) {
        super.log(this.removePasswordJsessionid(msg), msgLevel);
    }

    private @Nullable String removePasswordJsessionid(@Nullable String message) {
        return Utils.removePasswordJsessionid(message);
    }
}

