/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.oauth.TokenRequest;
import com.pageseeder.publishapi.oauth.TokenResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.annotation.Nullable;

public class PageseederConfig
extends Task
implements DynamicAttribute {
    private String name = "default";
    private boolean loadDefault = true;
    private @Nullable String file = null;
    private final List<Entry> entries = new ArrayList<Entry>();

    public void setDynamicAttribute(String name, String value) throws BuildException {
        if ("name".equalsIgnoreCase(name)) {
            this.name = value;
        } else if ("file".equalsIgnoreCase(name)) {
            this.file = value;
        } else if ("load-default".equalsIgnoreCase(name)) {
            this.loadDefault = "true".equalsIgnoreCase(value);
        } else {
            throw new BuildException("Unsupported attribute " + name);
        }
    }

    public Entry createEntry() {
        Entry entry = new Entry();
        this.entries.add(entry);
        return entry;
    }

    public void execute() throws BuildException {
        if (this.name == null || this.name.isEmpty()) {
            this.name = "default";
        }
        Properties props = new Properties();
        if (this.loadDefault) {
            this.setDefaultProperties(props);
        }
        if (this.file != null) {
            Object propFile = new File(this.file);
            if (!((File)propFile).exists()) {
                propFile = new File(this.getProject().getBaseDir(), this.file);
            }
            if (!((File)propFile).exists() || !((File)propFile).isFile()) {
                throw new BuildException("Invalid properties file");
            }
            try (FileInputStream fis = new FileInputStream((File)propFile);){
                Properties fileProps = new Properties();
                fileProps.load(fis);
                Enumeration<?> pnames = fileProps.propertyNames();
                while (pnames.hasMoreElements()) {
                    String n = (String)pnames.nextElement();
                    this.setProperty(props, true, n, fileProps.getProperty(n));
                }
            }
            catch (IOException e) {
                throw new BuildException("Failed to open, read or close properties file: " + e.getMessage(), (Throwable)e);
            }
        }
        for (Entry entry : this.entries) {
            this.setProperty(props, true, entry.getKey(), entry.getValue());
        }
        this.retrieveOAuthToken(props);
        Enumeration<?> pnames = props.propertyNames();
        while (pnames.hasMoreElements()) {
            String pname = pnames.nextElement().toString();
            this.getProject().setProperty(pname, props.getProperty(pname));
        }
    }

    private void setDefaultProperties(Properties props) {
        this.setProperty(props, false, "jsessionid", this.getProject().getProperty("ps-jsessionid"));
        this.setProperty(props, false, "scheme", "http");
        this.setProperty(props, false, "host", this.getProject().getProperty("ps-host"));
        this.setProperty(props, false, "port", this.getProject().getProperty("ps-port"));
        this.setProperty(props, false, "servlet.prefix", this.getProject().getProperty("ps-servletPrefix"));
        this.setProperty(props, false, "site.prefix", this.getProject().getProperty("ps-sitePrefix"));
        this.setProperty(props, false, "global.template", this.getProject().getProperty("ps-customFolder"));
        this.setProperty(props, false, "group.id", this.getProject().getProperty("ps-groupId"));
        this.setProperty(props, false, "group.name", this.getProject().getProperty("ps-groupName"));
        this.setProperty(props, false, "group.folder", this.getProject().getProperty("ps-groupFolder"));
        this.setProperty(props, false, "group.folder.no.prefix", this.getProject().getProperty("ps-groupFolderNoPrefix"));
        this.setProperty(props, false, "group.scheme", this.getProject().getProperty("ps-groupScheme"));
        this.setProperty(props, false, "group.host", this.getProject().getProperty("ps-groupHost"));
        this.setProperty(props, false, "group.port", this.getProject().getProperty("ps-groupPort"));
        this.setProperty(props, false, "group.template", this.getProject().getProperty("ps-style-owner"));
        this.setProperty(props, false, "custom.folder", this.getProject().getProperty("ps-customFolder"));
        this.setProperty(props, false, "working", this.getProject().getProperty("ps-working"));
        this.setProperty(props, false, "working.root", this.getProject().getProperty("ps-workingRoot"));
        this.setProperty(props, false, "documents.root", this.getProject().getProperty("ps-documentsRoot"));
        this.setProperty(props, false, "web.root", this.getProject().getProperty("ps-webRoot"));
        this.setProperty(props, false, "engine.url", this.getProject().getProperty("ps-engineUrl"));
        this.setProperty(props, false, "session.folder", this.getProject().getProperty("ps-sessionfolder"));
        this.setProperty(props, false, "uri.id", this.getProject().getProperty("ps-uriId"));
        this.setProperty(props, false, "uri.scheme", this.getProject().getProperty("ps-uriScheme"));
        this.setProperty(props, false, "uri.host", this.getProject().getProperty("ps-uriHost"));
        this.setProperty(props, false, "uri.port", this.getProject().getProperty("ps-uriPort"));
        this.setProperty(props, false, "uri.path", this.getProject().getProperty("ps-uriPath"));
        this.setProperty(props, false, "uri.path.no.prefix", this.getProject().getProperty("ps-uriPathNoPrefix"));
        this.setProperty(props, false, "uri.path.no.group", this.getProject().getProperty("ps-uriPathNoGroup"));
        this.setProperty(props, false, "uri.folder", this.getProject().getProperty("ps-uriFolder"));
        this.setProperty(props, false, "uri.folder.no.prefix", this.getProject().getProperty("ps-uriFolderNoPrefix"));
        this.setProperty(props, false, "uri.folder.no.group", this.getProject().getProperty("ps-uriFolderNoGroup"));
        this.setProperty(props, false, "uri.filename", this.getProject().getProperty("ps-uriFilename"));
        this.setProperty(props, false, "uri.filename.no.ext", this.getProject().getProperty("ps-uriFilenameNoExt"));
        this.setProperty(props, false, "uri.document.id", this.getProject().getProperty("ps-uriDocumentId"));
        this.setProperty(props, false, "uri.document.type", this.getProject().getProperty("ps-style-config"));
        this.setProperty(props, false, "uri.extension", this.getProject().getProperty("ps-uriExtension"));
        this.setProperty(props, false, "uri.publication.id", this.getProject().getProperty("ps-uriPublicationId"));
        this.setProperty(props, false, "uri.publication.type", this.getProject().getProperty("ps-uriPublicationType"));
        this.setProperty(props, false, "uri.url.type", this.getProject().getProperty("ps-urlType"));
        this.setProperty(props, false, "upload.path", this.getProject().getProperty("ps-uploadPath"));
        this.setProperty(props, true, "upload.folder", this.getProject().getProperty("ps-uploadFolder"));
        this.setProperty(props, false, "upload.filename", this.getProject().getProperty("ps-uploadFilename"));
        this.setProperty(props, false, "upload.filename.no.ext", this.getProject().getProperty("ps-uploadFilenameNoExt"));
        this.setProperty(props, false, "upload.extension", this.getProject().getProperty("ps-uploadExtension"));
        this.setProperty(props, false, "upload.confirmed", this.getProject().getProperty("ps-uploadConfirmed"));
        this.setProperty(props, false, "username", this.getProject().getProperty("ps-username"));
        this.setProperty(props, false, "user.id", this.getProject().getProperty("ps-userId"));
        this.setProperty(props, false, "user.firstname", this.getProject().getProperty("ps-userFirstname"));
        this.setProperty(props, false, "user.surname", this.getProject().getProperty("ps-userSurname"));
        this.setProperty(props, false, "user.token", this.getProject().getProperty("ps-userToken"));
        this.setProperty(props, false, "anticsrftoken", this.getProject().getProperty("ps-anticsrftoken"));
        this.setProperty(props, false, "batch.ids", this.getProject().getProperty("ps-batchIds"));
        this.setProperty(props, false, "search.filters", this.getProject().getProperty("ps-searchFilters"));
        this.setProperty(props, false, "search.question", this.getProject().getProperty("ps-searchQuestion"));
        this.setProperty(props, false, "search.question.fields", this.getProject().getProperty("ps-searchQuestionFields"));
        this.setProperty(props, false, "search.ranges", this.getProject().getProperty("ps-searchRanges"));
    }

    private void setProperty(Properties props, boolean allowEmpty, @Nullable String propName, @Nullable String propValue) {
        if (propName != null && propValue != null && (allowEmpty || !propValue.isEmpty())) {
            props.setProperty("ps.config." + this.name + "." + propName, propValue);
        }
    }

    private void retrieveOAuthToken(Properties props) {
        String portStr;
        String clientID = props.getProperty("ps.config." + this.name + ".client.id");
        if (clientID == null || clientID.isEmpty()) {
            return;
        }
        String clientSecret = props.getProperty("ps.config." + this.name + ".client.secret");
        if (clientSecret == null || clientSecret.isEmpty()) {
            this.getProject().log("Ignoring client.id value as client.secret is missing", 1);
            return;
        }
        StringBuilder s = new StringBuilder();
        String scheme = props.get("ps.config." + this.name + ".scheme").toString();
        s.append(scheme).append("://");
        s.append(props.get("ps.config." + this.name + ".host"));
        Object port = props.get("ps.config." + this.name + ".port");
        if (!(port == null || (portStr = port.toString()).isEmpty() || "443".equals(portStr) && "https".equals(scheme) || "80".equals(portStr) && "http".equals(scheme))) {
            s.append(":").append(port);
        }
        String urlBase = s.append(props.get("ps.config." + this.name + ".site.prefix")).toString();
        this.getProject().log("Retrieving OAuth Token using server " + urlBase, 2);
        TokenResponse resp = TokenRequest.newClientCredentials(clientID, clientSecret, urlBase).post();
        if (resp.isSuccessful()) {
            this.getProject().log("Successfully retrieved OAuth Token for " + resp.getMemberUsername(), 2);
            this.setProperty(props, false, "user.token", resp.getAccessToken());
            this.setProperty(props, false, "username", resp.getMemberUsername());
        } else {
            this.getProject().log("Failed to retrieve OAuth Token: " + resp.getError(), 0);
        }
    }

    public static class Entry {
        private @Nullable String key;
        private @Nullable String value;

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public @Nullable String getKey() {
            return this.key;
        }

        public @Nullable String getValue() {
            return this.value;
        }
    }
}

