/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.LoadingZoneDelete;
import com.pageseeder.publishapi.utils.ANTUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.annotation.Nullable;

public class LoadingZoneDeleteTask
extends Task {
    private @Nullable String path = null;
    private @Nullable String paths = null;
    private String config = "default";
    private @Nullable String group = null;

    public void setPath(String path) {
        this.path = path;
    }

    public void setPaths(String paths) {
        this.paths = paths;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void execute() throws BuildException {
        List<Object> errors;
        if (this.path == null && this.paths == null) {
            throw new BuildException("Path to download is not specified.");
        }
        if (this.group == null) {
            throw new BuildException("Group is not specified.");
        }
        if (this.path != null) {
            errors = this.deletePath(this.path);
        } else {
            String[] steps;
            errors = new ArrayList();
            for (String s : steps = this.paths.split("\\|")) {
                if (s.endsWith("/")) {
                    this.log("Path " + s + " is ignored as it points to a folder.", 1);
                    continue;
                }
                errors.addAll(this.deletePath(s));
            }
        }
        while (!errors.isEmpty()) {
            this.log((String)errors.remove(0), 0);
        }
    }

    private List<String> deletePath(String thepath) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            LoadingZoneDelete lzd = new LoadingZoneDelete(thepath, this.group, null, ANTUtils.buildConfig(this.getProject(), this.config));
            lzd.delete();
        }
        catch (Exception e) {
            errors.add("Failed to delete the path " + thepath + ": " + e.getMessage());
        }
        return errors;
    }
}

