/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.utils.ResponseHandler;
import com.pageseeder.publishapi.utils.ThreadLogger;
import com.pageseeder.publishapi.utils.ThreadPoller;
import com.pageseeder.publishapi.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request {
    private static final Logger LOGGER = LoggerFactory.getLogger(Request.class);
    private final ExternalConfig config;
    private final String pathname;
    private final Map<String, String> parameters;
    private long pollingIntervalMs = 2000L;
    private @Nullable ThreadLogger threadLogger = null;
    private @Nullable HttpURLConnection connection;
    private @Nullable String responseContentType = null;
    private @Nullable String responseContentEncoding = null;
    private String httpMethod = "GET";
    private boolean followRedirects = true;

    public Request(String path, ExternalConfig config) {
        this.pathname = path;
        this.config = config;
        this.parameters = new HashMap<String, String>();
    }

    public @Nullable ExternalConfig getConfig() {
        return this.config;
    }

    public void setFollowRedirects(boolean yes) {
        this.checkNoConnection();
        this.followRedirects = yes;
    }

    public void setHTTPMethod(@Nullable String method) {
        this.checkNoConnection();
        this.httpMethod = method == null ? "GET" : method;
    }

    public void addParameter(@Nullable String name, @Nullable String value) {
        this.checkNoConnection();
        if (name == null || value == null) {
            return;
        }
        this.parameters.put(name, value);
    }

    private void checkNoConnection() {
        if (this.connection != null) {
            throw new IllegalStateException("Too late, already connected to the PS server!");
        }
    }

    protected Iterator<String> getParameterNames() {
        return this.parameters.keySet().iterator();
    }

    public @Nullable String getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setThreadHandlingDetails(long milliseconds, @Nullable ThreadLogger logger) {
        this.pollingIntervalMs = milliseconds;
        this.threadLogger = logger;
    }

    private boolean isPost() {
        return "POST".equals(this.httpMethod) || "PATCH".equals(this.httpMethod);
    }

    public void send() throws PageseederException {
        if (this.connection != null) {
            throw new IllegalStateException("Too late, already connected to the PS server!");
        }
        StringBuilder path = new StringBuilder(this.pathname);
        if (!this.isPost()) {
            if (this.config.getJSessionID() == null && this.config.getUsername() != null && this.config.getPassword() != null) {
                this.parameters.put("username", this.config.getUsername());
                this.parameters.put("password", this.config.getPassword());
            }
            path.append(Utils.getUrlParamSeparator(path.toString())).append(Request.toQuery(this.parameters));
        }
        String host = this.config.getHost();
        String scheme = this.config.getScheme() != null ? this.config.getScheme() : "http";
        int port = this.config.getPort();
        if (path.charAt(0) != '/') {
            path.insert(0, '/');
        }
        String url = scheme + "://" + host + ":" + port + this.config.getPSPrefix() + path.toString();
        try {
            this.connectToUrl(url);
        }
        catch (IOException e) {
            String msg = "Error connecting to " + Utils.removePasswordJsessionid(url) + " : " + Utils.removePasswordJsessionid(e.getMessage());
            LOGGER.error(msg);
            throw new PageseederException(msg, e);
        }
    }

    private void connectToUrl(String urlString) throws IOException, PageseederException {
        URL url = new URL(urlString);
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setDoOutput(true);
        this.connection.setInstanceFollowRedirects(this.followRedirects);
        if ("PATCH".equals(this.httpMethod)) {
            this.connection.setRequestMethod("POST");
            this.connection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
        } else {
            this.connection.setRequestMethod(this.httpMethod);
        }
        this.connection.setRequestProperty("User-Agent", "Pageseeder External API " + Request.class.getPackage().getImplementationVersion());
        if (this.isPost()) {
            this.connection.setDoInput(true);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        }
        if (this.config.getUserToken() != null) {
            this.connection.setRequestProperty("Authorization", "Bearer " + this.config.getUserToken());
        } else if (this.config.getJSessionID() != null) {
            this.connection.setRequestProperty("Cookie", "JSESSIONID=" + this.config.getJSessionID());
            if (this.config.getAntiCSRFToken() != null) {
                this.connection.setRequestProperty("Anti-CSRF-Token", this.config.getAntiCSRFToken());
            }
        }
        this.connection.connect();
        if (this.isPost()) {
            StringBuilder contents = new StringBuilder();
            try {
                if (this.config.getJSessionID() == null && this.config.getUsername() != null && this.config.getPassword() != null) {
                    contents.append('&').append(Request.encodeParameter("username", this.config.getUsername()));
                    contents.append('&').append(Request.encodeParameter("password", this.config.getPassword()));
                }
                contents.append('&').append(Request.toQuery(this.parameters));
                if (contents.length() != 0) {
                    OutputStream dout = this.connection.getOutputStream();
                    dout.write(contents.substring(1).getBytes(StandardCharsets.UTF_8));
                    dout.flush();
                    dout.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error writing contents of POST request", (Throwable)ex);
                throw new PageseederException("Error writing contents of POST request: " + Utils.removePasswordJsessionid(ex.getMessage()), ex);
            }
        }
    }

    public void writeAllContent(String content, String encoding) throws PageseederException {
        try {
            this.writeAllContent(new ByteArrayInputStream(content.getBytes(encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new PageseederException("Invalid Encoding " + encoding, e);
        }
    }

    public void writeAllContent(InputStream in) throws PageseederException {
        if (this.connection == null) {
            throw new IllegalStateException("Cannot write before the connection has been established!");
        }
        if (!"POST".equalsIgnoreCase(this.httpMethod) && !"PUT".equals(this.httpMethod)) {
            throw new IllegalStateException("Only POST and PUT method allow input.");
        }
        try (InputStream inputStream = in;
             OutputStream os = this.connection.getOutputStream();){
            int read;
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
        }
        catch (IOException ex) {
            throw new PageseederException("Failed to write to connection: " + ex.getMessage(), ex);
        }
    }

    public @Nullable String getResponseAsString() throws PageseederException {
        return this.getResponseAsString(null);
    }

    public @Nullable String getResponseAsString(@Nullable Map<String, List<String>> headers) throws PageseederException {
        byte[] data = this.getResponse(headers, null);
        if (data != null && this.isTextResponse()) {
            try {
                return new String(data, this.responseContentEncoding == null ? "UTF-8" : this.responseContentEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                LOGGER.error("Invalid character encoding {}", (Object)this.responseContentEncoding, (Object)ex);
                return null;
            }
        }
        return null;
    }

    public byte @Nullable [] getResponse() throws PageseederException {
        return this.getResponse(null, null);
    }

    public void getResponse(OutputStream out) throws PageseederException {
        this.getResponse(null, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte @Nullable [] getResponse(@Nullable Map<String, List<String>> headers, @Nullable OutputStream out) throws PageseederException {
        int charsetIndex;
        String newUrl;
        int status;
        if (this.connection == null) {
            throw new IllegalStateException("You need to connect to the PS server first!");
        }
        String url = this.connection.getURL().toString();
        String message = null;
        try {
            status = this.connection.getResponseCode();
            message = this.connection.getResponseMessage();
        }
        catch (IOException e) {
            throw new PageseederException("Error reading response from the Pageseeder server: " + Utils.removePasswordJsessionid(e.getMessage()), e);
        }
        this.updateExternalConfig();
        if (status == 302 && this.followRedirects && (newUrl = this.connection.getHeaderField("Location")) != null) {
            this.connection.disconnect();
            try {
                this.connectToUrl(newUrl);
                return this.getResponse(headers, out);
            }
            catch (IOException e) {
                throw new PageseederException("Redirect failed: " + Utils.removePasswordJsessionid(e.getMessage()), e);
            }
        }
        if (headers != null) {
            headers.putAll(this.connection.getHeaderFields());
        }
        this.responseContentType = this.connection.getContentType();
        this.responseContentEncoding = this.connection.getContentEncoding();
        int n = charsetIndex = this.responseContentType == null ? -1 : this.responseContentType.toLowerCase().indexOf(";charset=");
        if (charsetIndex > 0) {
            this.responseContentEncoding = this.responseContentType.substring(charsetIndex + 9);
            this.responseContentType = this.responseContentType.substring(0, charsetIndex);
        }
        if (this.responseContentType == null) {
            this.responseContentType = "text/xml";
        }
        if (this.responseContentEncoding == null) {
            this.responseContentEncoding = "UTF-8";
        }
        byte[] data = null;
        try {
            OutputStream responseAsBytes;
            InputStream stream = this.httpStatusSuccessful(status) ? this.connection.getInputStream() : this.connection.getErrorStream();
            OutputStream outputStream = responseAsBytes = out != null ? out : new ByteArrayOutputStream();
            if (stream != null) {
                try {
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = stream.read(buffer)) != -1) {
                        responseAsBytes.write(buffer, 0, read);
                    }
                }
                finally {
                    stream.close();
                    responseAsBytes.close();
                }
            }
            if (out != null) {
                byte[] read = null;
                return read;
            }
            data = ((ByteArrayOutputStream)responseAsBytes).toByteArray();
        }
        catch (IOException ex) {
            LOGGER.error("Error reading response from the Pageseeder server: {}", (Object)ex.getMessage(), (Object)ex);
            if (this.httpStatusSuccessful(status)) {
                throw new PageseederException("Error reading response from the Pageseeder server: " + Utils.removePasswordJsessionid(ex.getMessage()), ex);
            }
        }
        finally {
            this.connection.disconnect();
            this.connection = null;
        }
        if (!this.httpStatusSuccessful(status)) {
            ResponseHandler handler = null;
            String xmlResponse = null;
            if (this.isXMLResponse() && data.length > 0) {
                try {
                    xmlResponse = new String(data, this.responseContentEncoding);
                    handler = ResponseHandler.readResponse(xmlResponse);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to parse XML response for error message", (Throwable)ex);
                }
            }
            String error = handler != null && handler.getMessage() != null ? handler.getMessage() : message;
            PageseederException exc = new PageseederException("HTTP Status: " + status + (String)(handler != null && handler.getErrorID() != null ? ", Error ID: " + handler.getErrorID() : "") + (String)(error != null ? ", Error message: " + error : "") + ", URL: " + Utils.removePasswordJsessionid(url));
            exc.setResponse(xmlResponse);
            exc.setHttpStatus(status);
            if (handler != null) {
                exc.setDate(handler.getDate());
                exc.setPSStackTrace(handler.getStacktrace());
            }
            throw exc;
        }
        if (status == 202 && this.isXMLResponse()) {
            return this.getThreadResponse(data);
        }
        return data;
    }

    private byte[] getThreadResponse(byte[] data) throws PageseederException {
        ThreadPoller poller = new ThreadPoller(this.config);
        poller.setPollingInterval(this.pollingIntervalMs);
        poller.setLogger(this.threadLogger);
        try {
            String resp = poller.poll(new String(data, this.responseContentEncoding));
            this.responseContentEncoding = "UTF-8";
            return resp.getBytes(StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new PageseederException("Failed to read data using encoding " + this.responseContentEncoding, ex);
        }
    }

    private void updateExternalConfig() {
        assert (this.connection != null);
        String cookie = this.connection.getHeaderField("Set-Cookie");
        if (cookie == null) {
            return;
        }
        for (String ck : cookie.split(";")) {
            @Nullable String[] pair = ck.split("=");
            if (pair.length <= 1 || pair[0] == null || !"jsessionid".equalsIgnoreCase(pair[0]) || pair[1] == null || pair[1].isEmpty()) continue;
            this.config.setJSessionID(pair[1]);
            break;
        }
    }

    private boolean httpStatusSuccessful(int status) {
        return status >= 200 && status <= 206;
    }

    private boolean isTextResponse() {
        return this.responseContentType != null && (this.responseContentType.startsWith("text/") || this.responseContentType.endsWith("xml") || this.responseContentType.endsWith("json"));
    }

    protected boolean isXMLResponse() {
        return this.responseContentType != null && (this.responseContentType.endsWith("/xml") || this.responseContentType.endsWith("+xml"));
    }

    private static String toQuery(Map<String, String> parameters) {
        ArrayList<String> pairs = new ArrayList<String>(parameters.size());
        for (Map.Entry<String, String> p : parameters.entrySet()) {
            pairs.add(Request.encodeParameter(p.getKey(), p.getValue()));
        }
        return String.join((CharSequence)"&", pairs);
    }

    private static String encodeParameter(String name, String value) {
        return URLEncoder.encode(name, StandardCharsets.UTF_8) + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8);
    }
}

