/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.furi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pageseeder.furi.Matchable;
import org.pageseeder.furi.Parameters;
import org.pageseeder.furi.TokenBase;
import org.pageseeder.furi.TokenOperator;
import org.pageseeder.furi.URICoder;
import org.pageseeder.furi.URITemplateSyntaxException;
import org.pageseeder.furi.Variable;

public class TokenOperatorPS
extends TokenBase
implements TokenOperator,
Matchable {
    protected static final Pattern PCHAR = Pattern.compile("(?:[\\w-_.~!$&'()*+,;=:@]|(?:%[0-9A-F]{2}))");
    private Operator _operator;
    private List<Variable> _vars;
    private Pattern _pattern;

    public TokenOperatorPS(Operator op, Variable var) throws NullPointerException {
        super(TokenOperatorPS.toExpression(op, var));
        if (op == null || var == null) {
            throw new NullPointerException("The operator must have a value");
        }
        this._operator = op;
        this._vars = new ArrayList<Variable>(1);
        this._vars.add(var);
        this._pattern = op.pattern(this._vars);
    }

    public TokenOperatorPS(Operator op, List<Variable> vars) throws NullPointerException {
        super(TokenOperatorPS.toExpression(op, vars));
        if (op == null || vars == null) {
            throw new NullPointerException("The operator must have a value");
        }
        this._operator = op;
        this._vars = vars;
        this._pattern = op.pattern(vars);
    }

    @Override
    public String expand(Parameters parameters) {
        return this._operator.expand(this._vars, parameters);
    }

    public Operator operator() {
        return this._operator;
    }

    @Override
    public List<Variable> variables() {
        return this._vars;
    }

    @Override
    public boolean isResolvable() {
        return this._operator.isResolvable(this._vars);
    }

    @Override
    public boolean resolve(String expanded, Map<Variable, Object> values) {
        if (this.isResolvable()) {
            this._operator.resolve(this._vars, expanded, values);
            return true;
        }
        return false;
    }

    @Override
    public boolean match(String part) {
        return this._pattern.matcher(part).matches();
    }

    @Override
    public Pattern pattern() {
        return this._pattern;
    }

    public static Operator toOperator(char c) {
        for (Operator o : Operator.values()) {
            if (o.character() != c) continue;
            return o;
        }
        return null;
    }

    public static TokenOperatorPS parse(String exp) throws URITemplateSyntaxException {
        String sexp = TokenOperatorPS.strip(exp);
        if (sexp.length() < 2) {
            throw new URITemplateSyntaxException(exp, "Cannot produce a valid token operator.");
        }
        char c = sexp.charAt(0);
        Operator operator = TokenOperatorPS.toOperator(c);
        if (operator == null) {
            throw new URITemplateSyntaxException(String.valueOf(c), "This operator is not supported");
        }
        List<Variable> variables = TokenOperatorPS.toVariables(sexp.substring(1));
        return new TokenOperatorPS(operator, variables);
    }

    private static String toExpression(Operator op, Variable var) {
        return "{" + op.character() + var.name() + '}';
    }

    private static String toExpression(Operator op, List<Variable> vars) {
        StringBuffer exp = new StringBuffer();
        exp.append('{');
        exp.append(op.character());
        boolean first = true;
        for (Variable v : vars) {
            if (!first) {
                exp.append(',');
            }
            exp.append(v.toString());
            first = false;
        }
        exp.append('}');
        return exp.toString();
    }

    public static enum Operator {
        QUERY_PARAMETER('?'){

            @Override
            public String expand(List<Variable> vars, Parameters parameters) {
                if (parameters == null) {
                    return "";
                }
                StringBuffer expansion = new StringBuffer();
                boolean first = true;
                for (Variable var : vars) {
                    String[] values;
                    if (!parameters.exists(var.name())) continue;
                    for (String value : values = var.values(parameters)) {
                        expansion.append(first ? (char)'?' : '&');
                        first = false;
                        expansion.append(var.name()).append('=').append(URICoder.encode(value));
                    }
                }
                return expansion.toString();
            }

            @Override
            boolean isResolvable(List<Variable> arg0) {
                return true;
            }

            @Override
            boolean resolve(List<Variable> vars, String value, Map<Variable, Object> values) {
                for (Variable var : vars) {
                    Pattern p = Pattern.compile("(?<=[&?]" + var.namePatternString() + "=)([^&#]*)");
                    Matcher m = p.matcher(value);
                    while (m.find()) {
                        values.put(var, m.group());
                    }
                }
                return true;
            }

            @Override
            Pattern pattern(List<Variable> vars) {
                StringBuffer pattern = new StringBuffer();
                pattern.append("\\?(");
                for (Variable var : vars) {
                    pattern.append('(');
                    pattern.append(var.namePatternString());
                    pattern.append("=[^&#]*)|");
                }
                pattern.append("&)*");
                return Pattern.compile(pattern.toString());
            }
        }
        ,
        PATH_PARAMETER(';'){

            @Override
            String expand(List<Variable> vars, Parameters parameters) {
                if (parameters == null) {
                    return "";
                }
                StringBuffer expansion = new StringBuffer();
                for (Variable var : vars) {
                    String[] values;
                    if (!parameters.exists(var.name())) continue;
                    for (String value : values = var.values(parameters)) {
                        expansion.append(';');
                        expansion.append(var.name());
                        if (value.length() <= 0) continue;
                        expansion.append('=').append(URICoder.encode(value));
                    }
                }
                return expansion.toString();
            }

            @Override
            boolean isResolvable(List<Variable> vars) {
                return true;
            }

            @Override
            boolean resolve(List<Variable> vars, String value, Map<Variable, Object> values) {
                for (Variable var : vars) {
                    Pattern p = Pattern.compile("(?<=;" + var.namePatternString() + "=)([^;/?#]*)");
                    Matcher m = p.matcher(value);
                    while (m.find()) {
                        values.put(var, m.group());
                    }
                }
                return true;
            }

            @Override
            Pattern pattern(List<Variable> vars) {
                StringBuffer pattern = new StringBuffer();
                pattern.append("(?:");
                for (Variable var : vars) {
                    pattern.append("(?:;");
                    pattern.append(var.namePatternString());
                    pattern.append("=[^;/?#]*)|");
                }
                pattern.append(";)*");
                return Pattern.compile(pattern.toString());
            }
        }
        ,
        PATH_SEGMENT('/'){

            @Override
            String expand(List<Variable> vars, Parameters parameters) {
                if (parameters == null) {
                    return "";
                }
                StringBuffer expansion = new StringBuffer();
                for (Variable var : vars) {
                    String[] values;
                    if (!parameters.exists(var.name())) continue;
                    for (String value : values = var.values(parameters)) {
                        expansion.append('/');
                        expansion.append(URICoder.encode(value));
                    }
                }
                return expansion.toString();
            }

            @Override
            boolean isResolvable(List<Variable> arg0) {
                return true;
            }

            @Override
            boolean resolve(List<Variable> vars, String value, Map<Variable, Object> values) {
                if (vars.size() != 1) {
                    throw new UnsupportedOperationException("Operator + cannot be resolved with multiple variables.");
                }
                values.put(vars.get(0), URICoder.decode(value));
                return true;
            }

            @Override
            Pattern pattern(List<Variable> vars) {
                return Pattern.compile("(?:/[^/?#]*)*");
            }
        }
        ,
        URI_INSERT('+'){

            @Override
            String expand(List<Variable> vars, Parameters parameters) {
                if (parameters == null) {
                    return "";
                }
                StringBuffer expansion = new StringBuffer();
                Iterator<Variable> i = vars.iterator();
                while (i.hasNext()) {
                    Variable var = i.next();
                    if (parameters.exists(var.name())) {
                        String[] values;
                        for (String value : values = var.values(parameters)) {
                            expansion.append(URICoder.minimalEncode(value));
                        }
                    }
                    if (!i.hasNext()) continue;
                    expansion.append(',');
                }
                return expansion.toString();
            }

            @Override
            boolean resolve(List<Variable> vars, String value, Map<Variable, Object> values) {
                if (vars.size() != 1) {
                    throw new UnsupportedOperationException("Operator + cannot be resolved with multiple variables.");
                }
                values.put(vars.get(0), URICoder.decode(value));
                return true;
            }

            @Override
            boolean isResolvable(List<Variable> vars) {
                return vars.size() == 1;
            }

            @Override
            Pattern pattern(List<Variable> vars) {
                return Pattern.compile("[^?#]*");
            }
        };

        private final char _c;

        private Operator(char c) {
            this._c = c;
        }

        public char character() {
            return this._c;
        }

        abstract boolean isResolvable(List<Variable> var1);

        abstract String expand(List<Variable> var1, Parameters var2);

        abstract Pattern pattern(List<Variable> var1);

        abstract boolean resolve(List<Variable> var1, String var2, Map<Variable, Object> var3);
    }
}

