/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.pdf.ant;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.pageseeder.pdf.util.ImageScaler;

public final class ProcessTask
extends Task {
    private File _source;
    private File _destination;

    public void setSrc(File pdf) {
        if (!pdf.exists()) {
            throw new BuildException("the PDF " + pdf.getName() + " doesn't exist");
        }
        if (pdf.isDirectory()) {
            throw new BuildException("the PDF " + pdf.getName() + " can't be a directory");
        }
        String name = pdf.getName();
        if (!name.endsWith(".pdf") && !name.endsWith(".pdf")) {
            this.log("presentation file should generally end with .pptx or .zip - but was " + name);
        }
        this._source = pdf;
    }

    public void setDest(File destination) {
        this._destination = destination;
        if (destination.exists() && !destination.isDirectory()) {
            throw new BuildException("the destination " + destination.getName() + " must be a directory");
        }
    }

    public void execute() throws BuildException {
        if (this._source == null) {
            throw new BuildException("Source presentation must be specified using 'src' attribute");
        }
        if (this._destination == null) {
            this._destination = this._source.getParentFile();
            this.log("Destination set to source directory " + this._destination.getAbsolutePath() + "");
        }
        this.log("Processing file");
        PDDocument document = null;
        try {
            document = PDDocument.load((File)this._source);
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            String name = this._source.getName();
            if (name.endsWith(".pdf")) {
                name = name.substring(0, name.length() - 4);
            }
            this._destination.mkdirs();
            String prefix = new File(this._destination, name + "-p").getAbsolutePath();
            BufferedImage bim = pdfRenderer.renderImageWithDPI(1, 300.0f, ImageType.RGB);
            boolean success = ImageIOUtil.writeImage((BufferedImage)bim, (String)(prefix + ".png"), (int)300);
            File[] files = this._destination.listFiles();
            if (files != null) {
                for (File f : files) {
                    BufferedImage image = ImageIO.read(f);
                    String iname = f.getName().substring(0, f.getName().length() - 4);
                    this.log("Downscaling " + f.getName());
                    this.scale(image, iname, 1000, "large");
                    this.scale(image, iname, 700, "normal");
                    this.scale(image, iname, 180, "small");
                    f.delete();
                }
            }
            PDFTextStripper stripper = new PDFTextStripper();
            int pages = document.getNumberOfPages();
            for (int page = 1; page <= pages; ++page) {
                this.log("Extracting text from page " + page);
                stripper.setStartPage(page);
                stripper.setEndPage(page);
                File file = new File(this._destination, name + "-p" + page + ".txt");
                OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
                stripper.writeText(document, (Writer)output);
                output.close();
            }
            this.log("Generating the JSON file");
            File json = new File(this._destination, name + ".json");
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(json), "utf-8");
            ProcessTask.generateJSON(document, output, name, "http://docviewer.local:8099/data/");
            output.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean scale(BufferedImage image, String name, int width, String size) throws IOException {
        BufferedImage large = ImageScaler.scale((BufferedImage)image, (int)width);
        File file = new File(this._destination, name + "-" + size + ".png");
        return ImageIO.write((RenderedImage)large, "png", file);
    }

    private static void generateJSON(PDDocument document, Writer writer, String id, String webpath) throws IOException {
        writer.append('{');
        PDDocumentInformation info = document.getDocumentInformation();
        ProcessTask.writeJSON("id", id, writer).append(',');
        String title = info.getTitle();
        ProcessTask.writeJSON("title", title != null ? title : id, writer).append(',');
        String description = info.getSubject();
        if (description != null) {
            ProcessTask.writeJSON("description", info.getSubject(), writer).append(',');
        }
        ProcessTask.writeJSON("pages", Integer.toString(document.getNumberOfPages()), writer).append(',');
        String contributor = info.getAuthor();
        if (contributor != null) {
            ProcessTask.writeJSON("contributor", contributor, writer).append(',');
        }
        ProcessTask.writeJSON("created_at", "Sat, 24 Apr 2010 05:09:21 +0000", writer).append(',');
        ProcessTask.writeJSON("updated_at", "Thu, 25 Oct 2012 18:28:03 +0000", writer).append(',');
        writer.append("\"resources\": {");
        writer.append("\"page\": {");
        ProcessTask.writeJSON("text", webpath + id + '/' + id + "-p{page}.txt", writer).append(',');
        ProcessTask.writeJSON("image", webpath + id + '/' + id + "-p{page}-{size}.png", writer);
        writer.append("},");
        ProcessTask.writeJSON("pdf", webpath + id + '/' + id + ".pdf", writer);
        writer.append("}");
        writer.append('}');
    }

    private static Writer writeJSON(String name, String value, Writer writer) throws IOException {
        writer.append('\"').append(name).append('\"').append(':');
        writer.append('\"').append(value).append('\"');
        return writer;
    }
}

