/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.upokecenter.cbor.CBORObject;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.data.AuthenticatorData;
import com.yubico.webauthn.data.AuthenticatorExtensionOutputs;
import com.yubico.webauthn.data.Extensions;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class AuthenticatorRegistrationExtensionOutputs
implements AuthenticatorExtensionOutputs {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticatorRegistrationExtensionOutputs.class);
    private final Extensions.CredentialProtection.CredentialProtectionPolicy credProtect;
    private final List<Extensions.Uvm.UvmEntry> uvm;

    @JsonCreator
    private AuthenticatorRegistrationExtensionOutputs(@JsonProperty(value="credProtect") Extensions.CredentialProtection.CredentialProtectionPolicy credProtect, @JsonProperty(value="uvm") List<Extensions.Uvm.UvmEntry> uvm) {
        this.credProtect = credProtect;
        this.uvm = uvm == null ? null : CollectionUtil.immutableList(uvm);
    }

    public static Optional<AuthenticatorRegistrationExtensionOutputs> fromAuthenticatorData(AuthenticatorData authData) {
        return authData.getExtensions().flatMap(AuthenticatorRegistrationExtensionOutputs::fromCbor);
    }

    static Optional<AuthenticatorRegistrationExtensionOutputs> fromCbor(CBORObject cbor) {
        AuthenticatorRegistrationExtensionOutputsBuilder b = AuthenticatorRegistrationExtensionOutputs.builder();
        Extensions.CredentialProtection.parseAuthenticatorExtensionOutput(cbor).ifPresent(b::credProtect);
        Extensions.Uvm.parseAuthenticatorExtensionOutput(cbor).ifPresent(b::uvm);
        AuthenticatorRegistrationExtensionOutputs result = b.build();
        if (result.getExtensionIds().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    @Override
    public Set<String> getExtensionIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.credProtect != null) {
            ids.add("credProtect");
        }
        if (this.uvm != null) {
            ids.add("uvm");
        }
        return ids;
    }

    public Optional<Extensions.CredentialProtection.CredentialProtectionPolicy> getCredProtect() {
        return Optional.ofNullable(this.credProtect);
    }

    public Optional<List<Extensions.Uvm.UvmEntry>> getUvm() {
        return Optional.ofNullable(this.uvm);
    }

    @Generated
    public static AuthenticatorRegistrationExtensionOutputsBuilder builder() {
        return new AuthenticatorRegistrationExtensionOutputsBuilder();
    }

    @Generated
    public AuthenticatorRegistrationExtensionOutputsBuilder toBuilder() {
        return new AuthenticatorRegistrationExtensionOutputsBuilder().credProtect(this.credProtect).uvm(this.uvm);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorRegistrationExtensionOutputs)) {
            return false;
        }
        AuthenticatorRegistrationExtensionOutputs other = (AuthenticatorRegistrationExtensionOutputs)o;
        Optional<Extensions.CredentialProtection.CredentialProtectionPolicy> this$credProtect = this.getCredProtect();
        Optional<Extensions.CredentialProtection.CredentialProtectionPolicy> other$credProtect = other.getCredProtect();
        if (this$credProtect == null ? other$credProtect != null : !((Object)this$credProtect).equals(other$credProtect)) {
            return false;
        }
        Optional<List<Extensions.Uvm.UvmEntry>> this$uvm = this.getUvm();
        Optional<List<Extensions.Uvm.UvmEntry>> other$uvm = other.getUvm();
        if (this$uvm == null ? other$uvm != null : !((Object)this$uvm).equals(other$uvm)) {
            return false;
        }
        Set<String> this$$getExtensionIds = this.getExtensionIds();
        Set<String> other$$getExtensionIds = other.getExtensionIds();
        return !(this$$getExtensionIds == null ? other$$getExtensionIds != null : !((Object)this$$getExtensionIds).equals(other$$getExtensionIds));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Extensions.CredentialProtection.CredentialProtectionPolicy> $credProtect = this.getCredProtect();
        result = result * 59 + ($credProtect == null ? 43 : ((Object)$credProtect).hashCode());
        Optional<List<Extensions.Uvm.UvmEntry>> $uvm = this.getUvm();
        result = result * 59 + ($uvm == null ? 43 : ((Object)$uvm).hashCode());
        Set<String> $$getExtensionIds = this.getExtensionIds();
        result = result * 59 + ($$getExtensionIds == null ? 43 : ((Object)$$getExtensionIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticatorRegistrationExtensionOutputs(credProtect=" + this.getCredProtect() + ", uvm=" + this.getUvm() + ")";
    }

    @Generated
    public static class AuthenticatorRegistrationExtensionOutputsBuilder {
        @Generated
        private Extensions.CredentialProtection.CredentialProtectionPolicy credProtect;
        @Generated
        private List<Extensions.Uvm.UvmEntry> uvm;

        @Generated
        AuthenticatorRegistrationExtensionOutputsBuilder() {
        }

        @Generated
        public AuthenticatorRegistrationExtensionOutputsBuilder credProtect(Extensions.CredentialProtection.CredentialProtectionPolicy credProtect) {
            this.credProtect = credProtect;
            return this;
        }

        @Generated
        public AuthenticatorRegistrationExtensionOutputsBuilder uvm(List<Extensions.Uvm.UvmEntry> uvm) {
            this.uvm = uvm;
            return this;
        }

        @Generated
        public AuthenticatorRegistrationExtensionOutputs build() {
            return new AuthenticatorRegistrationExtensionOutputs(this.credProtect, this.uvm);
        }

        @Generated
        public String toString() {
            return "AuthenticatorRegistrationExtensionOutputs.AuthenticatorRegistrationExtensionOutputsBuilder(credProtect=" + (Object)((Object)this.credProtect) + ", uvm=" + this.uvm + ")";
        }
    }
}

