/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.event;

import com.pageseeder.db.Database;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.webhook.event.Event;
import com.pageseeder.webhook.event.EventsCache;
import com.pageseeder.webhook.job.JobsQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventsThread.class);
    private static boolean shouldStop = false;
    public static int requestIntervalSeconds = 5;
    public static long requestSizeBytes = 2800L;
    private final EventsCache cache;
    private final JobsQueue queue;

    public EventsThread(EventsCache cache, JobsQueue queue) {
        this.cache = cache;
        this.queue = queue;
    }

    @Override
    public void run() {
        while (!shouldStop) {
            try {
                Collection<Event> events = this.cache.getNonQueuedEvents();
                if (!events.isEmpty()) {
                    for (Webhook webhook : this.listActiveWebhooks()) {
                        this.processBatch(webhook, events);
                    }
                    for (Event event : events) {
                        this.cache.setEventQueued(event.getID());
                    }
                }
            }
            catch (Throwable ex) {
                LOGGER.error("Webhook event thread error", ex);
            }
            long before = System.currentTimeMillis();
            while (!shouldStop && System.currentTimeMillis() - before < (long)requestIntervalSeconds * 1000L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    if (!shouldStop) {
                        LOGGER.warn("Events thread interrupted, closing!");
                    }
                    return;
                }
            }
            this.cache.setLastProcessedTimestamp(System.currentTimeMillis());
        }
    }

    public static void stop() {
        shouldStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Webhook> listActiveWebhooks() {
        Database db = null;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            LOGGER.error("Failed to open database", (Throwable)ex);
            return Collections.emptyList();
        }
        try {
            ArrayList<String> statuses = new ArrayList<String>();
            statuses.add(Webhook.Status.active.name());
            statuses.add(Webhook.Status.error.name());
            statuses.add(Webhook.Status.warning.name());
            List list = WebhookQuery.listWebhooksByStatus((Database)db, statuses);
            return list;
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load webhooks", (Throwable)ex);
            List<Webhook> list = Collections.emptyList();
            return list;
        }
        finally {
            if (db != null) {
                db.close();
            }
            db = null;
        }
    }

    private void processBatch(Webhook webhook, Collection<Event> events) {
        long currentSize = 0L;
        ArrayList<String> batch = new ArrayList<String>();
        for (Event event : events) {
            int eventSize;
            if (!webhook.includeEvent(event.getEventType())) continue;
            Collection<Event.EventGroup> egroups = event.getEventGroups();
            if (egroups == null || egroups.isEmpty()) {
                if (!webhook.getServer().booleanValue()) {
                    continue;
                }
            } else {
                boolean include = false;
                for (Event.EventGroup egroup : egroups) {
                    if (!webhook.includeGroup(egroup.name())) continue;
                    include = true;
                }
                if (!include) continue;
            }
            if ((long)(eventSize = event.getBytes(webhook)) > requestSizeBytes) {
                this.queue.add(webhook.getId(), Collections.singleton(event.getID()));
                continue;
            }
            if (currentSize + (long)eventSize > requestSizeBytes) {
                this.queue.add(webhook.getId(), batch);
                batch.clear();
            }
            currentSize += (long)eventSize;
            batch.add(event.getID());
        }
        if (!batch.isEmpty()) {
            this.queue.add(webhook.getId(), batch);
        }
    }
}

