/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.event;

import com.pageseeder.base.cache.SafeCacheWrapper;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.webhook.event.Event;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Element;
import org.eclipse.jdt.annotation.Nullable;

public class EventsCache
implements UniversallyPrintable {
    private final SafeCacheWrapper<String, Event> cache;
    private Set<String> eventFilters = ConcurrentHashMap.newKeySet();
    private @Nullable Long lastProcessedTimestamp = null;

    public EventsCache() {
        this.cache = SafeCacheWrapper.getInstance((String)"webhook-events");
    }

    public boolean includeEvent(@Nullable String type) {
        if (type == null) {
            return false;
        }
        if (this.eventFilters.contains("*.*")) {
            return true;
        }
        for (String supported : this.eventFilters) {
            if (supported.equals(type)) {
                return true;
            }
            if (!supported.endsWith(".*") || !type.startsWith(supported.replaceFirst("\\*$", ""))) continue;
            return true;
        }
        return false;
    }

    public void addFilters(Collection<String> filters) {
        if (filters.isEmpty()) {
            this.eventFilters.add("*.*");
        } else {
            this.eventFilters.addAll(filters);
        }
    }

    public void setLastProcessedTimestamp(long datetime) {
        this.lastProcessedTimestamp = datetime;
    }

    public @Nullable Long getLastProcessedTimestamp() {
        return this.lastProcessedTimestamp;
    }

    public void setFilters(Collection<String> filters) {
        ConcurrentHashMap.KeySetView<String, Boolean> newfilters = ConcurrentHashMap.newKeySet();
        newfilters.addAll(filters);
        this.eventFilters = newfilters;
    }

    public void add(Event event) {
        this.cache.put((Serializable)((Object)event.getID()), (Serializable)event);
    }

    public @Nullable Event get(String id) {
        return (Event)this.cache.get((Serializable)((Object)id));
    }

    public Collection<Event> getNonQueuedEvents() {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Object key : this.cache.getCache().getKeys()) {
            Event event;
            Element cached = this.cache.getElement((Serializable)((Object)((String)key)));
            if (cached == null || cached.isExpired() || (event = (Event)cached.getObjectValue()).isQueued()) continue;
            events.add(event);
        }
        return events;
    }

    public void setEventQueued(String id) {
        Event event = (Event)this.cache.get((Serializable)((Object)id));
        if (event != null) {
            this.cache.put((Serializable)((Object)event.getID()), (Serializable)event.cloneQueued());
        }
    }

    public void removeEventsWithoutID(Collection<String> idsToKeep, @Nullable Long createdBefore) {
        for (Object key : this.cache.getCache().getKeys()) {
            Element cached = this.cache.getElement((Serializable)((Object)((String)key)));
            if (cached == null || idsToKeep.contains(((Event)cached.getObjectValue()).getID()) || createdBefore == null || cached.getCreationTime() >= createdBefore) continue;
            this.cache.remove((Serializable)((Object)((String)key)));
        }
    }

    public void close() {
        this.cache.getCache().dispose();
    }

    public void print(OutputPrinter out) {
        out.startObject("events");
        out.field("count", (long)this.cache.getCache().getKeysWithExpiryCheck().size());
        out.startCollection("events", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Object id : this.cache.getCache().getKeys()) {
            Event event = (Event)this.cache.get((Serializable)((Object)((String)id)));
            if (event == null) continue;
            event.print(out);
        }
        out.endCollection();
        out.endObject();
    }
}

