/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageWebhookCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.webhook.manager.WebhookManager;
import com.pageseeder.webhook.web.WebhookDetails;
import java.io.IOException;
import java.util.Date;

@Requires(database=true, parameters={"webhook", "client"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class UpdateWebhook
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageWebhookCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        long webhookid = req.getParameter((Parameter)StandardParameters.webhook, -1L);
        Database db = req.getDatabase();
        Webhook webhook = WebhookQuery.getWebhook((Database)db, (Long)webhookid);
        if (webhook != null) {
            if (!WebhookDetails.checkClient(req, res, webhook)) {
                return;
            }
            WebhookDetails details = WebhookDetails.loadDetails(req, res, webhook);
            if (details == null) {
                return;
            }
            details.populate(webhook);
            webhook.setDateModified(new Date());
            if ((details.eventsUpdated() || details.statusUpdated()) && (Webhook.Status.active.equals((Object)webhook.getStatus()) || Webhook.Status.error.equals((Object)webhook.getStatus()) || Webhook.Status.warning.equals((Object)webhook.getStatus()))) {
                WebhookManager.getInstance().addEventFilters(webhook);
            }
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("webhook-modification");
            out.writeWebhook(webhook);
            out.endObject();
            out.flush();
        } else {
            res.setError(GeneratorStatus.NOT_FOUND, "Unable to find webhook");
        }
    }
}

