/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageWebhookCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import java.io.IOException;
import java.util.List;

@Requires(parameters={"client"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListWebhooksForClient
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageWebhookCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String clientId = req.getParameter((Parameter)StandardParameters.client);
        Database db = req.getDatabase();
        assert (clientId != null);
        Client client = OAuthQuery.getClient((Database)db, (String)clientId);
        if (client != null) {
            List webhooks = WebhookQuery.listWebhooksByClientID((Database)db, (Long)client.getId());
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("webhooks");
            out.startCollection("webhooks", OutputPrinter.CollectionOption.JSON_ONLY);
            for (Webhook webhook : webhooks) {
                out.writeWebhook(webhook);
            }
            out.endCollection();
            out.endObject();
            out.flush();
        } else {
            res.setError(GeneratorStatus.NOT_FOUND, "Unable to find client");
        }
    }
}

