/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageWebhookCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.webhook.manager.WebhookManager;
import com.pageseeder.webhook.web.WebhookDetails;
import java.io.IOException;

@Requires(parameters={"webhook", "client"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class DeleteWebhook
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageWebhookCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        long webhookId = req.getParameter((Parameter)StandardParameters.webhook, -1L);
        Database db = req.getDatabase();
        Webhook webhook = WebhookQuery.getWebhook((Database)db, (Long)webhookId);
        if (webhook != null) {
            if (!WebhookDetails.checkClient(req, res, webhook)) {
                return;
            }
            webhook.delete(db);
            req.getTransaction().commit();
            WebhookManager.getInstance().reloadEventFilters(db);
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("webhook-delete");
            out.endObject();
            out.flush();
        } else {
            res.setError(GeneratorStatus.NOT_FOUND, "Unable to find webhook");
        }
    }
}

