/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageWebhookCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.webhook.manager.WebhookManager;
import com.pageseeder.webhook.web.WebhookDetails;
import java.io.IOException;
import java.util.Date;

@Requires(database=true, parameters={"newclient", "url"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateWebhook
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageWebhookCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        WebhookDetails details = WebhookDetails.loadDetails(req, res, null);
        if (details == null) {
            return;
        }
        Client client = details.getClient();
        String url = details.getURL();
        assert (client != null && url != null);
        Webhook webhook = Webhook.create((Database)db, (Client)client, (String)url);
        Date now = new Date();
        webhook.setDateCreated(now);
        webhook.setDateModified(now);
        details.populate(webhook);
        webhook.setStatus(Webhook.Status.pending);
        webhook.insert(db);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("webhook-creation");
        out.writeWebhook(webhook);
        out.endObject();
        out.flush();
        res.setStatus(GeneratorStatus.CREATED);
        req.getTransaction().commitAndStart();
        WebhookManager.getInstance().startSendPing(webhook.getId());
    }
}

