/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.xref;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.uri.URIErrorID;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Requires(uri=true, group=true, database=true)
@PublicAPI
public final class XRefTreeLoader
implements Generator,
SingleCheck {
    private static final int MAX_NB_RESULTS = 500;
    private static final int MAX_DEPTH = 20;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Group group = req.getGroup();
        boolean forward = req.getParameter((Parameter)StandardParameters.forward, true);
        boolean reverse = req.getParameter((Parameter)StandardParameters.reverse, false);
        boolean allfragments = req.getParameter((Parameter)StandardParameters.allfragments, false);
        boolean duplicates = req.getParameter((Parameter)StandardParameters.duplicates, false);
        String properties_param = req.getParameter((Parameter)StandardParameters.properties);
        ArrayList<String> properties = properties_param == null ? new ArrayList() : Arrays.asList(Strings.split((String)properties_param, (char)','));
        String types_param = req.getParameter((Parameter)StandardParameters.types);
        List<String> types = types_param == null ? null : Arrays.asList(Strings.split((String)types_param, (char)','));
        String followtypes_param = req.getParameter((Parameter)StandardParameters.followtypes, "embed,transclude");
        List<String> followtypes = followtypes_param == null ? null : Arrays.asList(Strings.split((String)followtypes_param, (char)','));
        String version = req.getParameter((Parameter)StandardParameters.version);
        int forwarddepth = Long.valueOf(req.getParameter((Parameter)StandardParameters.forwarddepth, 0L)).intValue();
        int reversedepth = Long.valueOf(req.getParameter((Parameter)StandardParameters.reversedepth, 0L)).intValue();
        if (forwarddepth > 20) {
            forwarddepth = 20;
        }
        if (reversedepth > 20) {
            reversedepth = 20;
        }
        int xrefsize = Long.valueOf(req.getParameter((Parameter)StandardParameters.xrefsize, 500L)).intValue();
        xrefsize = DatabaseQuery.getMaxPageSize((int)xrefsize);
        Publication pub = null;
        String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
        if (!Strings.isEmpty((String)publicationid)) {
            pub = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)publicationid, (Host)uri.getHost());
        }
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        UniversalPrinter p = new UniversalPrinter((OutputPrinter)new XMLOutputPrinter((XMLWriter)xml));
        try {
            if (URIs.isExternal((URI)uri)) {
                p.writeExternalURI(uri, false, null);
            } else {
                p.writeURI(uri, false);
            }
            try {
                int nb = XRefTreeLoader.outputXRefs((XMLWriter)xml, db, group, uri, types, followtypes, null, version, pub, forward, reverse, forwarddepth, reversedepth, null, allfragments, duplicates, properties, new ArrayList<Long>(), 0, xrefsize);
                if (nb >= xrefsize) {
                    xml.openElement("limitreached");
                    xml.attribute("xrefs", xrefsize);
                    xml.closeElement();
                }
            }
            catch (URIException e) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.UNABLE_TO_RETRIEVE_XREFS, e.getMessage());
                p.close();
                return;
            }
            xml.closeElement();
        }
        finally {
            try {
                p.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
        XMLWriter out = res.getXMLWriter();
        out.writeXML(xml.toString());
    }

    private static int outputXRefs(XMLWriter xml, Database db, Group group, URI uri, List<String> types, List<String> followtypes, String xreftype, String version, Publication pub, boolean forward, boolean reverse, int forwarddepth, int reversedepth, String fragmentid, boolean allfragments, boolean duplicates, List<String> properties, List<Long> alreadyDone, int currentCounter, int maxSize) throws URIException {
        InputStream in;
        if (forwarddepth < 0 && reversedepth < 0 || !URIRule.isPSML((URI)uri)) {
            return 0;
        }
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
        if (version != null) {
            try {
                resolver.setReleaseId(XLinkRule.getValidRelease((Database)db, (URI)uri, null, (String)version, (Publication)pub));
            }
            catch (QueryFailedException e) {
                throw new URIException((Throwable)e);
            }
        }
        try {
            in = resolver.getContent(db);
        }
        catch (URIException e) {
            throw new URIException("Unable to resolve content for URI ID: " + uri.getId() + " Error: " + e.getMessage());
        }
        boolean fragment_found = true;
        int xrefcount = 0;
        if (xreftype != null && followtypes != null && !followtypes.contains(xreftype)) {
            if (fragmentid != null) {
                FindFragmentHandler xhandler = new FindFragmentHandler(fragmentid);
                XRefTreeLoader.parsePSML(uri, in, xhandler);
                fragment_found = xhandler.fragmentFound;
            }
        } else {
            boolean goReverse;
            boolean goForward = forward && (forwarddepth > 0 || !alreadyDone.contains(uri.getId()));
            boolean bl = goReverse = reverse && (reversedepth > 0 || !alreadyDone.contains(uri.getId()));
            if (forward && forwarddepth <= 0 && alreadyDone.contains(uri.getId()) || reverse && reversedepth <= 0 && alreadyDone.contains(uri.getId())) {
                try {
                    xml.openElement("omitted");
                    if (forward) {
                        xml.attribute("forward", Boolean.toString(forwarddepth <= 0 && alreadyDone.contains(uri.getId())));
                    }
                    if (reverse) {
                        xml.attribute("reverse", Boolean.toString(reversedepth <= 0 && alreadyDone.contains(uri.getId())));
                    }
                    xml.closeElement();
                }
                catch (IOException ex) {
                    throw new URIException("Failed to output omitted element: " + ex.getMessage());
                }
            }
            if (!duplicates && !alreadyDone.contains(uri.getId())) {
                alreadyDone.add(uri.getId());
            }
            XRefTreeHandler xhandler = new XRefTreeHandler(xml, db, group, uri, types, followtypes, version, pub, goForward, goReverse, forwarddepth, reversedepth, fragmentid, allfragments, duplicates, properties, alreadyDone, currentCounter, maxSize);
            XRefTreeLoader.parsePSML(uri, in, xhandler);
            fragment_found = fragmentid == null || xhandler.fragmentFound;
            xrefcount = xhandler.counter;
        }
        if (!fragment_found) {
            try {
                xml.openElement("fragmentnotfound");
                xml.attribute("id", fragmentid);
                xml.closeElement();
            }
            catch (IOException ex) {
                throw new URIException("Failed to output fragmentnotfound element: " + ex.getMessage());
            }
        }
        return xrefcount - currentCounter;
    }

    public static void parsePSML(URI uri, InputStream in, ContentHandler xhandler) throws URIException {
        ArrayList errors = new ArrayList();
        try {
            XMLHelpers.parse((InputStream)in, (ContentHandler)xhandler, errors, null);
        }
        catch (FoundationException e) {
            throw new URIException("Unable to parse content for URI ID: " + uri.getId() + " Error: " + e.getMessage());
        }
        if (!errors.isEmpty()) {
            StringBuilder err = new StringBuilder();
            for (String e : errors) {
                err.append(e).append("\n");
            }
            throw new URIException("Unable to parse content for URI ID: " + uri.getId() + " Error: " + err.toString());
        }
    }

    public static class XRefTreeHandler
    extends DefaultHandler {
        private static final String DOCUMENTINFO_ELEMENT = "documentinfo";
        private static final String LOCATOR_ELEMENT = "locator";
        private static final String FRAGMENT_ELEMENT = "fragment";
        private static final String METADATA_ELEMENT = "metadata";
        private static final String PROPERTIES_FRAGMENT_ELEMENT = "properties-fragment";
        private static final String PROPERTIES_ELEMENT = "properties";
        private static final String PROPERTY_ELEMENT = "property";
        private static final String VALUE_ELEMENT = "value";
        private static final String XREF_ELEMENT = "xref";
        private static final String BLOCKXREF_ELEMENT = "blockxref";
        private static final String REVERSEXREF_ELEMENT = "reversexref";
        private static final String IMAGE_ELEMENT = "image";
        private static final String LABELS = "labels";
        private static final String BLOCK_ELEMENT = "block";
        private static final String INLINE_ELEMENT = "inline";
        private static final String LABEL_ATTRIBUTE = "label";
        private static final String NAME_ATTRIBUTE = "name";
        private static final String DATATYPE_ATTRIBUTE = "datatype";
        private static final String ID_ATTRIBUTE = "id";
        private static final String URIID_ATTRIBUTE = "uriid";
        private static final String FRAGMENT_ATTRIBUTE = "fragment";
        private static final String DEFAULT_FRAGMENT_ID = "default";
        private final XMLWriter xml;
        private final Database db;
        private final Group group;
        private final URI uri;
        private final List<String> types;
        private final List<String> followtypes;
        private final String version;
        private final Publication pub;
        private final boolean forward;
        private final boolean reverse;
        private final int forwardDepth;
        private final int reverseDepth;
        private int counter;
        private final int size;
        private final List<Long> alreadyDone;
        private final String includeFragmentId;
        private final boolean allFragments;
        private final boolean duplicates;
        private final List<String> properties;
        private String property = null;
        private CharArrayWriter propertiesXml = new CharArrayWriter();
        private XMLWriter propertiesWriter = null;
        private boolean inProperty = false;
        private final ArrayDeque<String> elements = new ArrayDeque();
        private final Map<String, List<TreeXRef>> reverseXrefs = new HashMap<String, List<TreeXRef>>();
        private List<TreeXRef> xrefs = null;
        private String fragmentId = null;
        private final Map<String, String> fragmentLabels = new HashMap<String, String>();
        private final Deque<String> blockLabels = new ArrayDeque<String>();
        private final Deque<String> inlineLabels = new ArrayDeque<String>();
        private StringBuilder text = null;
        private boolean fragmentFound = false;

        public XRefTreeHandler(XMLWriter xml, Database db, Group group, URI uri, List<String> types, List<String> followtypes, String version, Publication pub, boolean forward, boolean reverse, int forwarddepth, int reversedepth, String fragmentid, boolean allfragments, boolean duplicates, List<String> properties, List<Long> done, int counter, int size) {
            this.xml = xml;
            this.db = db;
            this.group = group;
            this.uri = uri;
            this.types = types;
            this.followtypes = followtypes;
            this.version = version;
            this.pub = pub;
            this.forward = forward;
            this.reverse = reverse;
            this.forwardDepth = forwarddepth;
            this.reverseDepth = reversedepth;
            this.includeFragmentId = fragmentid;
            this.allFragments = allfragments;
            this.duplicates = duplicates;
            this.properties = properties;
            this.counter = counter;
            this.size = size;
            this.alreadyDone = done;
            this.propertiesWriter = new XMLWriterImpl((Writer)this.propertiesXml);
        }

        @Override
        public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
            if (LOCATOR_ELEMENT.equals(lName)) {
                this.fragmentId = atts.getValue("fragment");
            }
            if (DOCUMENTINFO_ELEMENT.equals(lName)) {
                this.fragmentId = DEFAULT_FRAGMENT_ID;
            }
            if (lName != null && lName.endsWith("fragment")) {
                this.fragmentId = atts.getValue(ID_ATTRIBUTE);
                if (this.fragmentId != null && this.fragmentId.equals(this.includeFragmentId)) {
                    this.fragmentFound = true;
                }
                this.xrefs = new ArrayList<TreeXRef>();
            }
            if (REVERSEXREF_ELEMENT.equals(lName) && this.fragmentId != null && this.reverse && this.counter < this.size) {
                try {
                    URI source = DatabaseQuery.getURIById((Database)this.db, (Long)Long.parseLong(atts.getValue(URIID_ATTRIBUTE)));
                    TreeXRef xref = new TreeXRef(source, this.fragmentId, atts);
                    if (this.types == null || this.types.contains(xref.getType())) {
                        List<TreeXRef> thexrefs = this.reverseXrefs.get(this.fragmentId);
                        if (thexrefs == null) {
                            thexrefs = new ArrayList<TreeXRef>();
                            this.reverseXrefs.put(this.fragmentId, thexrefs);
                        }
                        thexrefs.add(xref);
                        ++this.counter;
                    }
                }
                catch (QueryFailedException e) {
                    throw new SAXException("Unable to get source URI ID: " + atts.getValue(URIID_ATTRIBUTE) + " Error: " + e.getMessage());
                }
                catch (NumberFormatException e) {
                    throw new SAXException("reversexref attribute invalid uriid: " + atts.getValue(URIID_ATTRIBUTE));
                }
            }
            if ((XREF_ELEMENT.equals(lName) || BLOCKXREF_ELEMENT.equals(lName) || IMAGE_ELEMENT.equals(lName)) && this.fragmentId != null && this.forward && this.counter < this.size && !"true".equals(atts.getValue("unresolved"))) {
                TreeXRef xref = null;
                try {
                    xref = new TreeXRef(this.uri, this.fragmentId, atts, lName, true, false);
                    if (this.types == null || this.types.contains(xref.getType())) {
                        xref.retrieveTargetWithURIID(this.db);
                        xref.setProperty(this.property);
                        xref.setBlockLabels(this.blockLabels);
                        xref.setInlineLabels(this.inlineLabels);
                        this.xrefs.add(xref);
                        ++this.counter;
                    }
                }
                catch (FoundationException e) {
                    throw new SAXException("Unable to get target URI ID: " + xref.getTargetURIId() + " Error: " + e.getMessage());
                }
            }
            try {
                String label;
                if (LABELS.equals(lName) && LOCATOR_ELEMENT.equals(this.elements.peek())) {
                    this.text = new StringBuilder();
                } else if (BLOCK_ELEMENT.equals(lName)) {
                    label = atts.getValue(LABEL_ATTRIBUTE);
                    this.blockLabels.push(label != null ? label : "none");
                } else if (INLINE_ELEMENT.equals(lName)) {
                    label = atts.getValue(LABEL_ATTRIBUTE);
                    this.inlineLabels.push(label != null ? label : "none");
                } else if (PROPERTY_ELEMENT.equals(lName) && (PROPERTIES_FRAGMENT_ELEMENT.equals(this.elements.peek()) || PROPERTIES_ELEMENT.equals(this.elements.peek()))) {
                    this.property = atts.getValue(NAME_ATTRIBUTE);
                    if (this.properties.contains(this.property) && !XREF_ELEMENT.equals(atts.getValue(DATATYPE_ATTRIBUTE))) {
                        this.propertiesWriter.openElement(lName);
                        for (int i = 0; i < atts.getLength(); ++i) {
                            this.propertiesWriter.attribute(atts.getLocalName(i), atts.getValue(i));
                        }
                        this.inProperty = true;
                    }
                } else if (VALUE_ELEMENT.equals(lName) && this.inProperty) {
                    this.propertiesWriter.openElement(lName);
                    this.text = new StringBuilder();
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open element " + lName, ex);
            }
            this.elements.push(lName);
        }

        @Override
        public void endElement(String uri, String lName, String qName) throws SAXException {
            block31: {
                try {
                    String properties;
                    if (LOCATOR_ELEMENT.equals(lName)) {
                        this.fragmentId = null;
                    }
                    if (!(properties = this.propertiesXml.toString()).isEmpty() && METADATA_ELEMENT.equals(lName)) {
                        this.xml.openElement(METADATA_ELEMENT, true);
                        this.xml.writeXML(properties);
                        this.xml.closeElement();
                        this.propertiesXml.reset();
                        break block31;
                    }
                    if (lName == null || !lName.endsWith("fragment") && !DOCUMENTINFO_ELEMENT.equals(lName)) break block31;
                    List<TreeXRef> reversexrefs = this.reverseXrefs.get(this.fragmentId);
                    if ((this.includeFragmentId == null || this.fragmentId.equals(this.includeFragmentId) || DEFAULT_FRAGMENT_ID.equals(this.fragmentId) && this.reverseDepth >= 0) && (this.xrefs != null && !this.xrefs.isEmpty() || reversexrefs != null && !reversexrefs.isEmpty())) {
                        this.xml.openElement("fragment", true);
                        this.xml.attribute(ID_ATTRIBUTE, this.fragmentId);
                        String frag_labels = this.fragmentLabels.get(this.fragmentId);
                        if (frag_labels != null) {
                            this.xml.attribute(LABELS, frag_labels);
                        }
                        this.xml.writeXML(properties);
                        if (this.xrefs != null) {
                            for (TreeXRef xref : this.xrefs) {
                                xref.xRefToPSML(this.xml, null, null);
                                try {
                                    if ((this.includeFragmentId == null || this.fragmentId.equals(this.includeFragmentId)) && xref.getTargetURI() != null && URIRule.belongsToGroup((Database)this.db, (Long)xref.getTargetURI().getId(), (String)this.group.getName()) && this.forwardDepth >= 0) {
                                        this.counter += XRefTreeLoader.outputXRefs(this.xml, this.db, this.group, xref.getTargetURI(), this.types, this.followtypes, xref.getType(), this.version, this.pub, this.forward, this.reverse, this.forwardDepth - 1, -1, this.allFragments || DEFAULT_FRAGMENT_ID.equals(xref.getTargetFragment()) ? null : xref.getTargetFragment(), this.allFragments, this.duplicates, this.properties, this.alreadyDone, this.counter, this.size);
                                    }
                                }
                                catch (URIException | DatabaseException e) {
                                    throw new SAXException(e.getMessage());
                                }
                                this.xml.closeElement();
                            }
                        }
                        if (reversexrefs != null) {
                            for (TreeXRef xref : reversexrefs) {
                                xref.reverseXRefToPSML(this.xml, null, null);
                                try {
                                    if ((this.includeFragmentId == null || this.fragmentId.equals(this.includeFragmentId) || this.fragmentId.equals(DEFAULT_FRAGMENT_ID) && this.reverseDepth >= 0) && xref.getSourceURI() != null && URIRule.belongsToGroup((Database)this.db, (Long)xref.getSourceURI().getId(), (String)this.group.getName())) {
                                        this.counter += XRefTreeLoader.outputXRefs(this.xml, this.db, this.group, xref.getSourceURI(), this.types, this.followtypes, xref.getType(), this.version, this.pub, this.forward, this.reverse, -1, this.reverseDepth - 1, this.allFragments || DEFAULT_FRAGMENT_ID.equals(xref.getSourceFragment()) ? null : xref.getSourceFragment(), this.allFragments, this.duplicates, this.properties, this.alreadyDone, this.counter, this.size);
                                    }
                                }
                                catch (URIException | DatabaseException e) {
                                    throw new SAXException(e.getMessage());
                                }
                                this.xml.closeElement();
                            }
                        }
                        this.xml.closeElement();
                    } else if (!properties.isEmpty()) {
                        this.xml.openElement("fragment", true);
                        this.xml.attribute(ID_ATTRIBUTE, this.fragmentId);
                        String frag_labels = this.fragmentLabels.get(this.fragmentId);
                        if (frag_labels != null) {
                            this.xml.attribute(LABELS, frag_labels);
                        }
                        this.xml.writeXML(properties);
                        this.xml.closeElement();
                    }
                    this.fragmentId = null;
                    this.propertiesXml.reset();
                }
                catch (IOException e) {
                    throw new SAXException(e.getMessage());
                }
            }
            this.elements.pop();
            try {
                if (LABELS.equals(lName) && LOCATOR_ELEMENT.equals(this.elements.peek())) {
                    this.fragmentLabels.put(this.fragmentId, this.text.toString());
                    this.text = null;
                } else if (BLOCK_ELEMENT.equals(lName)) {
                    this.blockLabels.pop();
                } else if (INLINE_ELEMENT.equals(lName)) {
                    this.inlineLabels.pop();
                } else if (PROPERTY_ELEMENT.equals(lName)) {
                    this.property = null;
                    if (this.inProperty) {
                        this.propertiesWriter.closeElement();
                        this.inProperty = false;
                    }
                } else if (VALUE_ELEMENT.equals(lName) && this.inProperty) {
                    this.propertiesWriter.writeText(this.text.toString());
                    this.text = null;
                    this.propertiesWriter.closeElement();
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close element " + lName, ex);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text.append(ch, start, length);
            }
        }

        private class TreeXRef
        extends XRef {
            private String property;
            private String blockLabels;
            private String inlineLabels;

            public TreeXRef(URI source, String fragment, Attributes atts, String type, boolean readId, boolean ignoreURIID) {
                super(source, fragment, atts, type, readId, ignoreURIID);
                this.property = null;
                this.blockLabels = null;
                this.inlineLabels = null;
            }

            public TreeXRef(URI source, String fragment, Attributes atts) {
                super(source, fragment, atts);
                this.property = null;
                this.blockLabels = null;
                this.inlineLabels = null;
            }

            public void setProperty(String property) {
                this.property = property;
            }

            public void setBlockLabels(Deque<String> block) {
                this.blockLabels = null;
                if (block == null) {
                    return;
                }
                Iterator<String> labeli = block.iterator();
                while (labeli.hasNext()) {
                    if (this.blockLabels != null) {
                        this.blockLabels = this.blockLabels + "," + labeli.next();
                        continue;
                    }
                    this.blockLabels = labeli.next();
                }
            }

            public void setInlineLabels(Deque<String> inline) {
                this.inlineLabels = null;
                if (inline == null) {
                    return;
                }
                Iterator<String> labeli = inline.iterator();
                while (labeli.hasNext()) {
                    if (this.inlineLabels != null) {
                        this.inlineLabels = this.inlineLabels + "," + labeli.next();
                        continue;
                    }
                    this.inlineLabels = labeli.next();
                }
            }

            public void xRefToPSML(XMLWriter xml, Database db, Long contextGroupID) throws IOException {
                this.xRefToPSML(xml, db, false);
                if (this.blockLabels != null) {
                    xml.attribute("blocklabels", this.blockLabels);
                }
                if (this.inlineLabels != null) {
                    xml.attribute("inlinelabels", this.inlineLabels);
                }
                if (this.property != null) {
                    xml.attribute(XRefTreeHandler.PROPERTY_ELEMENT, this.property);
                }
            }

            public void reverseXRefToPSML(XMLWriter xml, Database db, Long contextGroupID) throws IOException {
                this.reverseXRefToPSML(xml, false);
                if (this.blockLabels != null) {
                    xml.attribute("blocklabels", this.blockLabels);
                }
                if (this.inlineLabels != null) {
                    xml.attribute("inlinelabels", this.inlineLabels);
                }
            }
        }
    }

    public static class FindFragmentHandler
    extends DefaultHandler {
        private static final String FRAGMENT_ELEMENT = "fragment";
        private static final String ID_ATTRIBUTE = "id";
        private final String fragmentId;
        private boolean fragmentFound = false;

        public FindFragmentHandler(String fragmentid) {
            this.fragmentId = fragmentid;
        }

        @Override
        public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
            String id;
            if (lName != null && lName.endsWith(FRAGMENT_ELEMENT) && (id = atts.getValue(ID_ATTRIBUTE)) != null && id.equals(this.fragmentId)) {
                this.fragmentFound = true;
            }
        }
    }
}

