/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.xref;

import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.document.StructureBuilder;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.xml.FatalErrorHandler;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XRefHandler
extends StructureBuilder {
    private static SAXParserFactory factory;
    private final List<String> errors = new ArrayList<String>();
    private final URI currentUri;
    private final Map<String, List<ContentPart>> _contents = new ConcurrentHashMap<String, List<ContentPart>>();
    private XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.Yes);
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private String currentFragment = null;
    private XMLStringWriter currentXRefContent = null;
    private XRef currentXRef = null;
    private boolean includeUnresolvedXRefs = false;
    private final boolean buildStructure;

    public XRefHandler(URI uri, boolean buildstructure) {
        if (uri == null) {
            throw new NullPointerException("No specified URI.");
        }
        this.currentUri = uri;
        this.buildStructure = buildstructure;
    }

    public void setIncludeUnresolvedXRefs(boolean includeUnresolvedxrefs) {
        this.includeUnresolvedXRefs = includeUnresolvedxrefs;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
        this.xml.setPrefixMapping(uri, prefix);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.buildStructure) {
            super.startElement(uri, localName, qName, atts);
        }
        if (("xref".equalsIgnoreCase(localName) || "blockxref".equalsIgnoreCase(localName) || "image".equalsIgnoreCase(localName) || "link".equalsIgnoreCase(localName)) && this.inMediaFragment == 0) {
            this.currentXRef = new XRef(this.currentUri, this.currentFragment, atts, localName, false, false);
            this.xml.writeText("");
            this.addContent(this.xml.toString());
            this.addContent(this.currentXRef);
            this.currentXRefContent = new XMLStringWriter(XML.NamespaceAware.Yes);
        } else if (this.currentXRefContent != null) {
            this.currentXRefContent.openElement(localName, true);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.currentXRefContent.attribute(atts.getLocalName(i), atts.getValue(i));
            }
        } else {
            if (("section".equalsIgnoreCase(localName) || PSMLContentUtils.isFragmentElement((String)localName)) && this.inMediaFragment == 0) {
                String frag = atts.getValue("id");
                if (frag != null) {
                    this.currentFragment = frag;
                }
                if (this.currentFragment != null) {
                    this._contents.put(this.currentFragment, new ArrayList());
                }
                this.resetWriters();
            } else if ("properties".equalsIgnoreCase(localName) && this.inMediaFragment == 0) {
                this.currentFragment = "default";
                this._contents.put(this.currentFragment, new ArrayList());
                this.resetWriters();
            }
            if (this.currentFragment != null) {
                this.xml.openElement(uri, localName, true);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String auri = atts.getURI(i);
                    if (auri != null && auri.length() == 0) {
                        auri = null;
                    }
                    this.xml.attribute(auri, atts.getLocalName(i), atts.getValue(i));
                }
            }
        }
        if (PSMLContentUtils.isMediaFragmentElement((String)localName)) {
            ++this.inMediaFragment;
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (PSMLContentUtils.isMediaFragmentElement((String)localName)) {
            --this.inMediaFragment;
        }
        if (this.buildStructure) {
            super.endElement(uri, localName, name);
        }
        if (("xref".equalsIgnoreCase(localName) || "blockXref".equalsIgnoreCase(localName) || "image".equalsIgnoreCase(localName) || "link".equalsIgnoreCase(localName)) && this.inMediaFragment == 0) {
            String content;
            if (this.currentXRef == null) {
                return;
            }
            this.resetWriters();
            String string = content = this.currentXRefContent == null ? null : this.currentXRefContent.toString();
            if (content != null && !content.isEmpty()) {
                String title;
                this.currentXRef.setContent(content);
                if ("manual".equals(this.currentXRef.getDisplay()) && ((title = this.currentXRef.getTitle()) == null || title.isEmpty())) {
                    this.currentXRef.setTitle(XMLHelpers.xmlToText((String)content));
                }
            }
            this.currentXRef = null;
            this.currentXRefContent = null;
        } else if (this.currentXRefContent != null) {
            this.currentXRefContent.closeElement();
        } else {
            if (this.currentFragment != null) {
                this.xml.writeXML("</" + name + ">");
            }
            if ((PSMLContentUtils.isFragmentElement((String)localName) || "properties".equalsIgnoreCase(localName)) && this.inMediaFragment == 0) {
                this.addContent(this.xml.toString());
                if (this.currentFragment != null) {
                    boolean removeContents = !"properties".equalsIgnoreCase(localName);
                    List<ContentPart> parts = this._contents.get(this.currentFragment);
                    for (int i = 0; removeContents && i < parts.size(); ++i) {
                        if (parts.get((int)i).xrefContent == null) continue;
                        removeContents = false;
                    }
                    if (removeContents) {
                        this._contents.remove(this.currentFragment);
                    }
                }
                this.currentFragment = null;
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buildStructure) {
            super.characters(ch, start, length);
        }
        if (this.currentXRef != null) {
            this.currentXRefContent.writeText(ch, start, length);
        } else if (this.currentFragment != null) {
            this.xml.writeText(ch, start, length);
        }
    }

    public void endDocument() throws SAXException {
        this.addContent(this.xml.toString());
    }

    public Iterator<String> getFragments() {
        return this._contents.keySet().iterator();
    }

    public StringBuilder getContents(String fragment) {
        StringBuilder newContents = new StringBuilder();
        List<ContentPart> contents = this._contents.get(fragment);
        if (contents != null) {
            for (ContentPart part : contents) {
                newContents.append(part.toString());
            }
        }
        return newContents;
    }

    public Iterator<XRef> getXRefs(String fragment) {
        ArrayList<XRef> xrefs = new ArrayList<XRef>();
        List<ContentPart> contents = this._contents.get(fragment);
        if (contents != null) {
            for (ContentPart part : contents) {
                if (part.xrefContent == null) continue;
                xrefs.add(part.xrefContent);
            }
        }
        return xrefs.iterator();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setOnlyFragment(String fragment) {
        this.currentFragment = fragment;
    }

    public void parse(InputStream xmlContents) throws SAXException, IOException, ParserConfigurationException {
        if (factory == null) {
            XRefHandler.initFactory();
        }
        XMLReader reader = factory.newSAXParser().getXMLReader();
        reader.setContentHandler((ContentHandler)((Object)this));
        reader.setErrorHandler((ErrorHandler)new FatalErrorHandler());
        reader.parse(new InputSource(xmlContents));
    }

    private static void initFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory f = XMLHelpers.safeSAXParserFactory();
        f.setValidating(false);
        f.setNamespaceAware(true);
        factory = f;
    }

    private void resetWriters() {
        this.xml = new XMLStringWriter(XML.NamespaceAware.Yes);
        for (String prefix : this.namespaces.keySet()) {
            this.xml.setPrefixMapping(this.namespaces.get(prefix), prefix);
        }
    }

    private void addContent(String content) {
        if (this.currentFragment == null) {
            return;
        }
        List<ContentPart> contents = this._contents.get(this.currentFragment);
        if (contents == null) {
            return;
        }
        contents.add(new ContentPart(content));
    }

    private void addContent(XRef xref) {
        if (this.currentFragment == null) {
            return;
        }
        List<ContentPart> contents = this._contents.get(this.currentFragment);
        if (contents == null) {
            return;
        }
        contents.add(new ContentPart(xref, this.includeUnresolvedXRefs));
    }

    private static class ContentPart {
        private final String stringContent;
        private final XRef xrefContent;
        private final boolean includeUnresolvedXRefs;

        public ContentPart(String content) {
            this.stringContent = content;
            this.xrefContent = null;
            this.includeUnresolvedXRefs = false;
        }

        public ContentPart(XRef xref, boolean unresolved) {
            this.stringContent = null;
            this.xrefContent = xref;
            this.includeUnresolvedXRefs = unresolved;
        }

        public String toString() {
            if (this.stringContent != null) {
                return this.stringContent;
            }
            if (this.xrefContent.getUriid() != null || this.includeUnresolvedXRefs) {
                XMLStringWriter xsw = new XMLStringWriter(XML.NamespaceAware.No);
                try {
                    this.xrefContent.xRefToPSML((XMLWriter)xsw, null, true, true);
                }
                catch (IOException ex) {
                    throw new UnforeseenException((Throwable)ex);
                }
                return xsw.toString();
            }
            return "";
        }
    }
}

