/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ws;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import com.pageseeder.ws.Event;
import com.pageseeder.ws.JsonMessage;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class FragmentEditingEvent
implements Event {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private String author;
    private long authorid = -1L;
    private long uriid;
    private String fragment;
    private @Nullable String type;
    private String datetime;
    private long editid = -1L;

    protected FragmentEditingEvent() {
        this.datetime = ISO8601.format((long)System.currentTimeMillis(), (ISO8601)ISO8601.DATETIME);
    }

    public FragmentEditingEvent(long uriid, String fragment, Member author, XLink edit, String type) {
        this.uriid = uriid;
        this.authorid = author.getId();
        this.fragment = Objects.requireNonNull(fragment);
        this.author = author.getFirstName() + " " + author.getSurname();
        this.editid = edit.getId();
        this.datetime = ISO8601.format((long)edit.getDate().getTime(), (ISO8601)ISO8601.DATETIME);
        this.type = Objects.requireNonNull(type);
    }

    public long getUriid() {
        return this.uriid;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getFragment() {
        return this.fragment;
    }

    public @Nullable String getType() {
        return this.type;
    }

    public long getAuthorid() {
        return this.authorid;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public void setFragment(String fragment) {
        if (!LocatorRule.isValidFragmentID((String)fragment)) {
            throw new IllegalArgumentException("Invalid fragment ID");
        }
        this.fragment = fragment;
    }

    public void setType(@Nullable String type) {
        if (type != null && !type.matches("^\\w+$")) {
            throw new IllegalArgumentException("Invalid type");
        }
        this.type = type;
    }

    public long getEditid() {
        return this.editid;
    }

    public String getDatetime() {
        return this.datetime;
    }

    @Override
    public JsonMessage toMessage() {
        try {
            return new JsonMessage(MAPPER.writer().writeValueAsString((Object)this));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static @Nullable FragmentEditingEvent parse(String json) {
        try {
            return (FragmentEditingEvent)MAPPER.readValue(json, FragmentEditingEvent.class);
        }
        catch (IOException ex) {
            LoggerFactory.getLogger((String)FragmentEditingEvent.class.getName()).warn("Unable to parse event: {}", (Object)ex.getMessage());
            return null;
        }
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

