/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.version;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddVersionCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.uri.URIUtils;
import com.pageseeder.version.CreatePublicationVersionThread;
import java.io.IOException;
import java.util.Date;
import org.eclipse.jdt.annotation.Nullable;

@Requires(group=true, database=true, member=true, parameters={"name", "publicationid"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateVersionForPublication
implements Generator,
SingleCheck {
    private static final String PUBLICATION_ATTRIBUTE = "com.pageseeder.version.CreateVersionForPublication.publication";

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        Publication pub = this.loadPublication(req);
        if (pub == null) {
            return new NoCheck();
        }
        req.getHttpServletRequest().setAttribute(PUBLICATION_ATTRIBUTE, (Object)pub);
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new AddVersionCheck(req.getGroup(), DatabaseQuery.getURIById((Database)req.getDatabase(), (Long)pub.getRootURIId())));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Member member = req.getMember();
        Group group = req.getGroup();
        Database db = req.getDatabase();
        assert (group != null && member != null);
        String title = req.getNonEmptyParameter((Parameter)StandardParameters.name);
        String content = req.getNonEmptyParameter((Parameter)StandardParameters.description);
        String labels = req.getNonEmptyParameter((Parameter)StandardParameters.labels);
        String notify_param = req.getParameter((Parameter)StandardParameters.notify, "silent");
        if (!URIUtils.checkLabels(res, labels)) {
            return;
        }
        if (title == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "A version name is required.");
            return;
        }
        if ("original".equalsIgnoreCase(title = title.trim()) || "current".equalsIgnoreCase(title)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Version name cannot be 'original' or 'current'.");
            return;
        }
        if (title.length() > 250) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Version name cannot be more than 250 characters.");
            return;
        }
        Notify notify = Notify.fromString((String)notify_param);
        if (notify == Notify.UNKNOWN || notify == Notify.MINIMAL) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid notify parameter.");
            return;
        }
        Publication publication = (Publication)req.getHttpServletRequest().getAttribute(PUBLICATION_ATTRIBUTE);
        if (publication == null) {
            publication = this.loadPublication(req);
        }
        if (publication == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid publicationid parameter.");
            return;
        }
        UserDetails userdetails = new UserDetailsManager().get(db, member.getId(), false);
        boolean isReviewer = !MemberRule.isContributorForGroup((UserDetails)userdetails, (String)group.getName());
        CreatePublicationVersionThread.Version version = new CreatePublicationVersionThread.Version(title, member, new Date(), isReviewer, group, content, labels == null ? null : Strings.split((String)labels, (char)','), notify);
        CreatePublicationVersionThread thread = new CreatePublicationVersionThread(member.getUsername(), group, publication, version);
        ProcessManager.getInstance().start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("version-creation");
        thread.print((OutputPrinter)out);
        out.endObject();
        out.flush();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }

    private @Nullable Publication loadPublication(GeneratorRequest req) throws DatabaseException {
        String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
        assert (publicationid != null);
        Host host = GroupURIRule.getDefaultGroupURI((Group)req.getGroup()).getHost();
        return DatabaseQuery.getPublicationByPublicationIDHost((Database)req.getDatabase(), (String)publicationid, (Host)host);
    }
}

