/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.version;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddVersionCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.version.ArchivePublicationVersionThread;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;

@Requires(group=true, database=true, member=true, parameters={"versionid", "publicationid"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class ArchiveVersionForPublication
implements Generator,
SingleCheck {
    private static final String PUBLICATION_ATTRIBUTE = "com.pageseeder.version.ArchiveVersionForPublication.publication";

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        Publication pub = this.loadPublication(req);
        if (pub == null) {
            return new NoCheck();
        }
        req.getHttpServletRequest().setAttribute(PUBLICATION_ATTRIBUTE, (Object)pub);
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new AddVersionCheck(req.getGroup(), DatabaseQuery.getURIById((Database)req.getDatabase(), (Long)pub.getRootURIId())));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Member member = req.getMember();
        Group group = req.getGroup();
        Database db = req.getDatabase();
        assert (group != null && member != null);
        Publication publication = (Publication)req.getHttpServletRequest().getAttribute(PUBLICATION_ATTRIBUTE);
        if (publication == null) {
            publication = this.loadPublication(req);
        }
        if (publication == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid publicationid parameter.");
            return;
        }
        XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)req.getParameter((Parameter)StandardParameters.versionid, -1L));
        if (XLinks.isArchived((XLink)xl)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.COMMENT_ARCHIVED);
            return;
        }
        if (xl == null || !"Documentation-Release".equals(xl.getContentRole()) && !"Documentation-Version".equals(xl.getContentRole())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.NOT_A_VERSION);
            return;
        }
        Collection att = xl.getAttached();
        if (!att.isEmpty()) {
            XLink pub_xlink = ((XLinkForAttachedXLink)att.iterator().next()).getAttachedXLink();
            if (pub_xlink == null || !pub_xlink.getId().equals(publication.getXLinkId())) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.VERSION_ON_DIFFERENT_URI, "The version is not attached to this publication.");
                return;
            }
        } else {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.VERSION_ON_DIFFERENT_URI, "The version is not attached to a publication.");
            return;
        }
        ArchivePublicationVersionThread thread = new ArchivePublicationVersionThread(member.getUsername(), group, publication, xl.getId());
        ProcessManager.getInstance().start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("version-archive");
        thread.print((OutputPrinter)out);
        out.endObject();
        out.flush();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }

    private @Nullable Publication loadPublication(GeneratorRequest req) throws DatabaseException {
        String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
        Group group = req.getGroup();
        assert (publicationid != null && group != null);
        Host host = GroupURIRule.getDefaultGroupURI((Group)group).getHost();
        return DatabaseQuery.getPublicationByPublicationIDHost((Database)req.getDatabase(), (String)publicationid, (Host)host);
    }
}

