/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.validation;

import com.pageseeder.validation.CachedResults;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.svrl.SVRLParser;

public class ValidationResults {
    private final @Nullable CachedResults results;
    private final boolean cacheable;
    private final boolean schemaNotFound;
    private final @Nullable String errorMessage;
    private @Nullable List<String> failedAssertions = null;
    private final boolean urlMetadataRequested;

    public ValidationResults(String error, boolean schemaNotFound) {
        this.results = null;
        this.errorMessage = error;
        this.cacheable = false;
        this.schemaNotFound = schemaNotFound;
        this.urlMetadataRequested = false;
    }

    public ValidationResults(CachedResults results, boolean cacheable, boolean urlMetadataRequested) {
        this.results = results;
        this.errorMessage = null;
        this.cacheable = cacheable;
        this.schemaNotFound = false;
        this.urlMetadataRequested = urlMetadataRequested;
    }

    public @Nullable String getSVRLResults() {
        return this.results == null ? null : new String(this.results.getSVRLResults(), StandardCharsets.UTF_8);
    }

    public boolean isValid() {
        return this.results != null && this.results.isValid();
    }

    public boolean hasError() {
        return !this.isValid();
    }

    public @Nullable String getErrorMessage() {
        return this.errorMessage;
    }

    public List<String> listFailedAssertions() {
        if (this.failedAssertions == null) {
            this.failedAssertions = this.loadFailedAssertions();
        }
        return this.failedAssertions;
    }

    private List<String> loadFailedAssertions() {
        List<String> list;
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(this.results.getSVRLResults()), StandardCharsets.UTF_8);
        try {
            list = SVRLParser.parse((Reader)reader).getFailedAsserts().stream().map(assertOrReport -> assertOrReport.getText().toPlainText()).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SchematronException ex) {
                return Collections.singletonList(ex.getMessage());
            }
        }
        reader.close();
        return list;
    }

    public boolean wasValidated() {
        return this.results != null;
    }

    public boolean areCacheable() {
        return this.cacheable;
    }

    public boolean wasSchemaNotFound() {
        return this.schemaNotFound;
    }

    public boolean urlMetadataRequested() {
        return this.urlMetadataRequested;
    }

    protected @Nullable CachedResults getCachedResults() {
        return this.results;
    }
}

