/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import net.sf.ehcache.util.concurrent.ConcurrentHashMap;

public final class SessionTracker {
    private static final Map<String, TrackedSession> trackedSessions = new ConcurrentHashMap();

    private SessionTracker() {
    }

    public static Collection<TrackedSession> getTrackedSessions() {
        return trackedSessions.values();
    }

    public static class TrackedSession
    implements Serializable {
        private final String username;
        private final long since;
        private final int timeout;

        TrackedSession(String username, long since, int timeout) {
            this.username = username;
            this.since = since;
            this.timeout = timeout;
        }

        public String username() {
            return this.username;
        }

        public long since() {
            return this.since;
        }

        public int timeout() {
            return this.timeout;
        }
    }

    public static class Listener
    implements HttpSessionAttributeListener {
        public void attributeAdded(HttpSessionBindingEvent event) {
            if ("ps-username".equals(event.getName())) {
                HttpSession session = event.getSession();
                String username = event.getValue().toString();
                trackedSessions.put(Listener.asKey(session.getId()), new TrackedSession(username, session.getCreationTime(), session.getMaxInactiveInterval()));
            }
        }

        public void attributeRemoved(HttpSessionBindingEvent event) {
            if ("ps-username".equals(event.getName())) {
                HttpSession session = event.getSession();
                trackedSessions.remove(Listener.asKey(session.getId()));
            }
        }

        public void attributeReplaced(HttpSessionBindingEvent event) {
        }

        private static String asKey(String sessionId) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                return Base64.getEncoder().encodeToString(md.digest(sessionId.getBytes(StandardCharsets.UTF_8)));
            }
            catch (NoSuchAlgorithmException ex) {
                return sessionId;
            }
        }
    }
}

