/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemberTempFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemberTempFiles.class);

    private MemberTempFiles() {
    }

    public static File getTempFolder(Member member, Group group) throws IOException {
        Objects.requireNonNull(member, "member");
        Objects.requireNonNull(group, "group");
        return MemberTempFiles.getTempFolder(member.getId(), group.getName());
    }

    public static File getTempFolder(Long memberId, String groupname) throws IOException {
        Objects.requireNonNull(memberId, "member ID");
        Objects.requireNonNull(groupname, "group name");
        return MemberTempFiles.getTempFolder(memberId.toString(), groupname);
    }

    public static File getTempFolder(String folder, String groupname) throws IOException {
        Objects.requireNonNull(folder, "folder");
        Objects.requireNonNull(groupname, "group name");
        File groupRoot = MemberTempFiles.descendantFile(new File(Settings.getDocumentPath()), groupname.replace('-', File.separatorChar));
        if (!groupRoot.exists() && !groupRoot.mkdirs()) {
            throw new IllegalArgumentException("Failed to create root folder for group " + groupname);
        }
        File tempFolder = new File(groupRoot, ".temp");
        if (!tempFolder.exists() && !tempFolder.mkdir()) {
            throw new IllegalArgumentException("Failed to create temp folder for group " + groupname);
        }
        File memberTempFolder = MemberTempFiles.descendantFile(tempFolder, folder);
        if (!memberTempFolder.exists() && !memberTempFolder.mkdirs()) {
            throw new IllegalArgumentException("Failed to create temp folder for group " + groupname + " and folder " + folder);
        }
        return memberTempFolder;
    }

    private static File descendantFile(File base, String path) throws IOException {
        File descendant = new File(base, path);
        if (!descendant.getCanonicalPath().startsWith(base.getCanonicalPath())) {
            LOGGER.error("Path results in a file outside base folder: {}", (Object)path);
            throw new IOException("Path results in a file outside base folder");
        }
        return descendant;
    }
}

