/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import com.pageseeder.utils.FilenameTransform;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class DynamicStrings {
    private DynamicStrings() {
    }

    public static String process(String src, Map<String, String> parameters, int number, Date date) throws ParseException {
        DynamicString ds = DynamicString.parse(src, null, false);
        return ds.process(parameters, number, date);
    }

    public static String toSQLLike(String src, int number, @Nullable String transform, boolean path) throws ParseException {
        String tf;
        boolean hasTrim = transform != null && transform.contains("trim");
        String string = tf = hasTrim ? transform.replaceFirst("(,trim)|(trim,)|(^trim$)", "") : transform;
        if (path) {
            StringBuilder transformed = new StringBuilder();
            String[] elements = src.split("((?<=/)|(?=/))");
            boolean ignoreNextIfSlash = false;
            for (String element : elements) {
                if ("/".equals(element)) {
                    if (!ignoreNextIfSlash) {
                        transformed.append('/');
                    }
                    ignoreNextIfSlash = true;
                    continue;
                }
                String source = hasTrim ? FilenameTransform.transformPath(element, "trim") : element;
                DynamicString ds = DynamicString.parse(source, tf, path);
                transformed.append(ds.toSQLLike(number));
                ignoreNextIfSlash = false;
            }
            return transformed.toString();
        }
        String source = hasTrim ? FilenameTransform.transformPath(src, "trim") : src;
        DynamicString ds = DynamicString.parse(source, tf, path);
        return ds.toSQLLike(number);
    }

    public static String explain(String src) throws ParseException {
        DynamicString ds = DynamicString.parse(src, null, false);
        return ds.explain();
    }

    private static class NumberPart
    implements Part {
        private final char symbol;
        private final int digits;
        private final boolean overflow;
        private final int argument;

        public NumberPart(char symbol, int digits, boolean overflow, int argument) {
            this.symbol = symbol;
            this.digits = digits;
            this.overflow = overflow;
            this.argument = argument;
        }

        @Override
        public void write(StringBuilder out, Map<String, String> parameters, int number, Date date) {
            int value = this.getValue(number, date);
            String format = this.format(value);
            out.append(format);
        }

        @Override
        public void sqlLike(StringBuilder out, int number, @Nullable String transform, boolean path) {
            if (this.symbol == 'N' || this.symbol == 'P' || this.symbol == 'Q' || this.symbol == 'K') {
                out.append(this.format(this.getValue(number, null)));
            } else {
                out.append('%');
            }
        }

        public int getValue(int number, @Nullable Date date) {
            switch (this.symbol) {
                case 'N': {
                    return number;
                }
                case 'P': {
                    return number / this.argument;
                }
                case 'Q': {
                    return number / this.argument + 1;
                }
                case 'K': {
                    return number / 1000;
                }
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            switch (this.symbol) {
                case 'Y': {
                    return calendar.get(1);
                }
                case 'M': {
                    return calendar.get(2) + 1;
                }
                case 'D': {
                    return calendar.get(5);
                }
                case 'W': {
                    return calendar.get(3);
                }
            }
            return 0;
        }

        public String format(int value) {
            Object format = Integer.toString(value);
            if (this.digits > 1) {
                int diff = this.digits - ((String)format).length();
                if (diff > 0) {
                    format = "0".repeat(diff) + (String)format;
                } else if (diff < 0 && !this.overflow) {
                    format = ((String)format).substring(((String)format).length() - this.digits);
                }
            }
            return format;
        }

        @Override
        public void explain(StringBuilder out) {
            out.append('[');
            switch (this.symbol) {
                case 'N': {
                    out.append("autonumber");
                    break;
                }
                case 'P': {
                    out.append("autonumber div ").append(this.argument);
                    break;
                }
                case 'Q': {
                    out.append("autonumber div ").append(this.argument).append(" + 1");
                    break;
                }
                case 'K': {
                    out.append("autonumber div 1000");
                    break;
                }
                case 'Y': {
                    out.append("year");
                    break;
                }
                case 'M': {
                    out.append("month");
                    break;
                }
                case 'D': {
                    out.append("day of year");
                    break;
                }
                case 'W': {
                    out.append("week of year");
                }
            }
            if (this.digits > 1) {
                out.append(this.overflow ? ", min " : ", last ");
                out.append(this.digits).append(" digits");
            }
            out.append(']');
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append('{');
            for (int i = 0; i < this.digits - 1; ++i) {
                out.append(this.overflow ? (char)'0' : (char)this.symbol);
            }
            out.append(this.symbol);
            if (this.argument > 0) {
                out.append(this.argument);
            }
            out.append('}');
            return out.toString();
        }

        public static NumberPart parse(String part) throws ParseException {
            Pattern p = Pattern.compile("(0*)([NPQKYMDW]+)(\\d*)");
            Matcher m = p.matcher(part);
            boolean matches = m.matches();
            if (matches) {
                char symbol = m.group(2).charAt(0);
                int digits = m.group(1).length() + m.group(2).length();
                boolean overflow = digits <= 1 || !m.group(1).isEmpty();
                int argument = !m.group(3).isEmpty() ? Integer.parseInt(m.group(3)) : 0;
                return new NumberPart(symbol, digits, overflow, argument);
            }
            throw new ParseException("Not a valid dynamic element", 0);
        }
    }

    private static class ParameterPart
    implements Part {
        private final String name;

        private ParameterPart(String name) {
            this.name = name;
        }

        @Override
        public void write(StringBuilder out, Map<String, String> parameters, int number, Date date) {
            String value = parameters.get(this.name);
            if (value != null) {
                out.append(value);
            }
        }

        @Override
        public void sqlLike(StringBuilder out, int number, @Nullable String transform, boolean path) {
            out.append('%');
        }

        public static ParameterPart parse(String part) throws ParseException {
            if (part.length() < 2) {
                throw new ParseException("Invalid dynamic parameter {" + part + "}", 0);
            }
            return new ParameterPart(part.substring(1));
        }

        @Override
        public void explain(StringBuilder out) {
            out.append("[valueof=").append(this.name).append("]");
        }

        public String toString() {
            return "{$" + this.name + "}";
        }
    }

    private static class StaticPart
    implements Part {
        private final String s;

        public StaticPart(String s) {
            this.s = s;
        }

        @Override
        public void write(StringBuilder out, Map<String, String> parameters, int number, Date date) {
            out.append(this.s);
        }

        @Override
        public void explain(StringBuilder out) {
            out.append('\"').append(this.s).append('\"');
        }

        @Override
        public void sqlLike(StringBuilder out, int number, @Nullable String transform, boolean path) {
            if (transform != null && path) {
                out.append(FilenameTransform.transformPath(this.s, transform));
            } else if (transform != null) {
                out.append(FilenameTransform.transform(this.s, transform));
            } else {
                out.append(this.s);
            }
        }

        public String toString() {
            return this.s;
        }
    }

    private static interface Part {
        public void write(StringBuilder var1, Map<String, String> var2, int var3, Date var4);

        public void explain(StringBuilder var1);

        public void sqlLike(StringBuilder var1, int var2, @Nullable String var3, boolean var4);
    }

    private static final class DynamicString {
        private final @Nullable String transform;
        private final boolean path;
        private final List<Part> parts;

        private DynamicString(List<Part> parts, @Nullable String transform, boolean path) {
            this.parts = parts;
            this.transform = transform;
            this.path = path;
        }

        public static DynamicString parse(String src, @Nullable String transform, boolean path) throws ParseException {
            ArrayList<Part> parts = new ArrayList<Part>();
            Pattern p = Pattern.compile("\\{([^}}]+)\\}");
            Matcher m = p.matcher(src);
            int end = 0;
            while (m.find(end)) {
                if (m.start() > end) {
                    parts.add(new StaticPart(src.substring(end, m.start())));
                }
                try {
                    String dynamic = m.group(1);
                    if (dynamic.charAt(0) == '$') {
                        parts.add(ParameterPart.parse(dynamic));
                    } else {
                        parts.add(NumberPart.parse(dynamic));
                    }
                }
                catch (ParseException ex) {
                    throw new ParseException(ex.getMessage(), m.start() + 1 + ex.getErrorOffset());
                }
                end = m.end();
            }
            if (end < src.length()) {
                parts.add(new StaticPart(src.substring(end)));
            }
            return new DynamicString(parts, transform, path);
        }

        public String process(Map<String, String> parameters, int number, Date date) {
            StringBuilder out = new StringBuilder();
            for (Part p : this.parts) {
                p.write(out, parameters, number, date);
            }
            return out.toString();
        }

        public String toSQLLike(int number) {
            StringBuilder out = new StringBuilder();
            for (Part p : this.parts) {
                p.sqlLike(out, number, this.transform, this.path);
            }
            return out.toString();
        }

        public String explain() {
            StringBuilder out = new StringBuilder();
            for (int i = 0; i < this.parts.size(); ++i) {
                if (i > 0) {
                    out.append(" + ");
                }
                this.parts.get(i).explain(out);
            }
            return out.toString();
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            for (Part p : this.parts) {
                out.append(p.toString());
            }
            return out.toString();
        }
    }
}

