/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import java.util.ArrayList;

public final class CSVParser {
    private static final char COMMA = ',';
    private static final char QUOTE = '\"';

    private CSVParser() {
    }

    public static String[] parse(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        int from = 0;
        int to = line.indexOf(44);
        boolean inQuote = false;
        while (to >= 0) {
            int length = to - from;
            if (length > 0) {
                char first = line.charAt(from);
                char last = line.charAt(to - 1);
                if (inQuote) {
                    if (last == '\"') {
                        inQuote = false;
                    }
                } else if (first == '\"' && (length == 1 || length > 1 && last != '\"')) {
                    inQuote = true;
                }
            }
            if (!inQuote) {
                tokens.add(CSVParser.unquote(line.substring(from, to)));
                from = to + 1;
            }
            to = line.indexOf(44, inQuote ? to + 1 : from);
        }
        tokens.add(CSVParser.unquote(line.substring(from)));
        return tokens.toArray(new String[0]);
    }

    private static String unquote(String value) {
        String clean = value;
        int length = clean.length();
        if (length > 1 && clean.charAt(0) == '\"' && clean.charAt(length - 1) == '\"') {
            clean = clean.substring(1, length - 1);
        }
        return clean;
    }
}

