/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.url;

import com.pageseeder.display.WebImage;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class FaviconImage
implements WebImage,
Serializable {
    private static final long serialVersionUID = 20210202L;
    private final String etag;
    private final long lastModified;

    protected FaviconImage(long lastModified, String etag) {
        this.lastModified = lastModified;
        this.etag = etag;
    }

    @Override
    public String getEtag() {
        return this.etag;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void write(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String etagToMatch = req.getHeader("If-None-Match");
        if (etagToMatch != null) {
            if (etagToMatch.equals(this.getEtag())) {
                res.setStatus(304);
                this.writeCommonHeaders(res);
                return;
            }
        } else {
            try {
                long since = req.getDateHeader("If-Modified-Since");
                if (since > 0L && since == this.getLastModified()) {
                    res.setStatus(304);
                    this.writeCommonHeaders(res);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.write(res);
    }

    protected void writeCommonHeaders(HttpServletResponse res) {
        res.setDateHeader("Date", System.currentTimeMillis());
        res.setHeader("ETag", this.etag);
        res.setHeader("Cache-Control", "max-age=604800");
    }
}

