/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.ValidateThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(group=true, member=true, uri=true, parameters={"schema"})
@PublicAPI
public final class ValidateFolder
implements Generator,
MultipleCheck {
    public List<PermissionCheck> getPermissionChecks(GeneratorRequest req) {
        Group group = req.getGroup();
        ArrayList<PermissionCheck> checks = new ArrayList<PermissionCheck>();
        checks.add((PermissionCheck)new ViewMemberCheck(req.getMember()));
        checks.add((PermissionCheck)new EditURICheck(group, req.getURI()));
        if (req.getParameter((Parameter)StandardParameters.shared, false)) {
            checks.add((PermissionCheck)new EditGroupCheck(group));
        }
        return checks;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Object path;
        Member member = req.getMember();
        URI uri = req.getURI();
        Group group = req.getGroup();
        assert (member != null && group != null && uri != null);
        if (uri == null || !"folder".equals(uri.getType())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NOT_A_FOLDER);
            return;
        }
        if (GroupRule.isProject((Group)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, group.getName() + " is a project");
            return;
        }
        String schematron = req.getParameter((Parameter)StandardParameters.schema);
        assert (schematron != null);
        String extension = req.getParameter((Parameter)StandardParameters.extension);
        String documenttype = req.getParameter((Parameter)StandardParameters.documenttype);
        boolean includeSubDirectories = req.getParameter((Parameter)StandardParameters.include_descendants, false);
        boolean shared = req.getParameter((Parameter)StandardParameters.shared, false);
        if (!schematron.endsWith(".sch")) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Schema must end with .sch");
            return;
        }
        String mediatype = null;
        if (extension != null) {
            mediatype = Settings.get((SettingsFile)SettingsFile.MIME, (String)extension);
        }
        ValidateThread thread = ValidateThread.newInstance(member.getUsername(), group, schematron);
        thread.setFailuresOnly(req.getParameter((Parameter)StandardParameters.failuresonly, false));
        thread.setReportAttribute("folder", uri.getPath());
        thread.setReportAttribute("folderuri", uri.getId().toString());
        thread.setReportAttribute("extension", extension);
        thread.setReportAttribute("documenttype", documenttype);
        thread.setReportAttribute("include-subdirectories", includeSubDirectories ? "true" : "false");
        thread.setReportAttribute("member-name", MemberRule.getFullName((Member)member));
        if (shared) {
            thread.setOutputFilename(RuleUtils.replaceNonFilenameChars((String)((!Strings.isEmpty((String)documenttype) ? "psml_" + documenttype : "document" + (String)(!Strings.isEmpty((String)extension) ? "_" + extension : "")) + "_" + schematron.substring(0, schematron.length() - 4) + ".xml")));
        }
        if (!((String)(path = uri.getPath())).endsWith("/")) {
            path = (String)path + "/";
        }
        try {
            Collection children = !includeSubDirectories ? DatabaseQuery.getURIsBySchemeHostPortDirectoryMediaDocumentType((Database)req.getDatabase(), (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)path, (String)mediatype, (String)documenttype, (boolean)false) : DatabaseQuery.getURIsBySchemeHostPortSubpathMediaDocumentType((Database)req.getDatabase(), (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)path, (String)mediatype, (String)documenttype);
            boolean foundOne = false;
            for (URI child : children) {
                if (!this.shouldValidate(child)) continue;
                thread.addURIToValidate(child.getId());
                foundOne = true;
            }
            if (!foundOne) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NO_URIS_TO_PROCESS, "No documents to validate!");
                return;
            }
        }
        catch (QueryFailedException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load documents in folder: " + ex.getMessage());
            return;
        }
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("folder-validation");
        thread.toXML(xml);
        xml.closeElement();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }

    private boolean shouldValidate(URI uri) {
        return !"folder".equals(uri.getType());
    }
}

