/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ErrorID;

public enum URIErrorID implements ErrorID
{
    ILLEGAL_FILENAME(4609, "Illegal character in filename."),
    ILLEGAL_ARCHIVE(4610, "The 'archive' folder for a group cannot be removed."),
    ALREADY_ARCHIVED(4611, "The URI is already archived."),
    NO_DEFAULT_GROUPURI(4612, "There is no default Group URI."),
    NOT_A_FOLDER(4613, "The URI is not a folder."),
    UNSUPPORTED_MEDIA_TYPE(4614, "The URI is not the correct media type."),
    NO_URIS_TO_PROCESS(4615, "No URIs to process."),
    NO_SCHEMA_SPECIFIED(4616, "Missing schema or schematron to validate."),
    DOCUMENT_ID_EXISTING(4617, "The document ID is already being used."),
    INVALID_DOCUMENT_ID(4618, "Document ID has invalid characters."),
    XREF_PROCESSING_ERROR(4619, "Error processing XRefs."),
    FRAGMENT_CREATION_ERROR(4620, "Error creating fragment."),
    VALIDATION_ERROR(4621, "Content validation error."),
    INVALID_DATE(4622, "Date is invalid."),
    EDIT_CLASH(4623, "Someone has modified this content while you were viewing it."),
    EXISTING_URL(4625, "There is already a URI with this URL."),
    INVALID_URL(4626, "Invalid URL."),
    URI_NOT_FOUND(4627, "URI not found."),
    INVALID_SIZE(4628, "Invalid size."),
    EDIT_NOT_FOUND(4629, "Edit not found."),
    INVALID_DESTINATION(4630, "Invalid destination."),
    AMBIGUOUS_REQUEST(4631, "Two contradictory parameters have been specified."),
    FRAGMENT_NOT_FOUND(4632, "Fragment not found."),
    IN_ANOTHER_DEFAULT_GROUP_FOLDER(4633, "URI is in the default group folder for another group."),
    FRAGMENT_NOT_IN_STRUCTURE(4640, "Fragment not in structure."),
    STATUS_REQUIRED(4641, "Status is required."),
    INVALID_PUBLICATION_ID(4642, "Invalid publication ID must follow pattern [a-zA-Z0-9_-]+ and not be more than 250 characters."),
    INVALID_PUBLICATION_TYPE(4643, "Invalid publication type must follow pattern [a-zA-Z0-9_]+ and not be more than 250 characters."),
    XREF_LOOP(4644, "XRef loop detected."),
    FRAGMENT_CASE_MISMATCH(4645, "A fragment with this ID exists with a different case."),
    INVALID_URL_DOMAIN(4646, "Domain is not allowed for this URL type."),
    INVALID_URL_MEDIATYPE(4647, "Media type is not allowed for this URL type."),
    NOT_ARCHIVED(4648, "The URI is not archived."),
    PREVIOUS_LOCATION_UNKNOWN(4649, "The previous location of the URI is unknown."),
    FOLDER_MISSING(4650, "The folder is missing."),
    FOLDER_INVALID(4651, "The folder is invalid."),
    FRAGMENT_EXISTS(4652, "The fragment already exists."),
    FRAGMENT_INVALID(4653, "The fragment is invalid."),
    LABELS_INVALID(4654, "Invalid labels - must follow pattern [a-zA-Z0-9_\\-,]*"),
    PRIORITY_INVALID(4655, "Invalid priority - must follow pattern [a-zA-Z0-9, _-]+"),
    STATUS_INVALID(4656, "Invalid status - must follow pattern [a-zA-Z0-9, _-]+"),
    PUBLICATION_ID_EXISTING(4657, "The publication ID is already being used"),
    UNABLE_TO_RETRIEVE_XREFS(25089, "Unable to retrieve XRefs"),
    INVALID_PSML_CONFIG_FILE(25090, "Invalid PSML configuration file"),
    UNABLE_TO_GENERATE_CONFIG_FILE(25091, "Unable to generate PSML config file");

    private final int id;
    private final String message;

    private URIErrorID(int id, String message) {
        if (id < 0) {
            throw new IndexOutOfBoundsException("Error ID must be >= 0");
        }
        this.id = id;
        this.message = message;
    }

    public int id() {
        return this.id;
    }

    public String message() {
        return this.message;
    }
}

