/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.url.URLResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.LoggerFactory;

@Requires(database=true, member=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ProcessExternalURIMetadata
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (!URIs.isExternal((URI)req.getURI())) {
            return new ForbiddenCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditAllURLsCheck());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        boolean overwrite = "true".equals(req.getParameter((Parameter)StandardParameters.overwrite, "false"));
        String metadataProperties = req.getParameter((Parameter)StandardParameters.metadata_properties, "");
        ArrayList<String> props = new ArrayList<String>();
        for (String prop : metadataProperties.split(",")) {
            if (Strings.isEmpty((String)prop)) continue;
            props.add(prop);
        }
        URI uri = req.getURI();
        boolean updated = false;
        URLResolver resolver = new URLResolver(overwrite, true, props);
        try {
            updated = resolver.resolve(uri, req.getMember(), req.getDatabase());
        }
        catch (FoundationException ex) {
            LoggerFactory.getLogger(ProcessExternalURIMetadata.class).error("Failed to process URL metadata", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to process URL metadata: " + ex.getMessage());
            return;
        }
        if (updated) {
            req.getTransaction().commitAndStart();
            ChangesManager.getInstance().modifyURI(req.getDatabase(), new ChangesBatch("Reprocessing metadata for single URI"), uri, Collections.emptyList());
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("metadata-process");
        out.field("updated", updated);
        out.writeURI(uri);
        out.endObject();
        out.flush();
    }
}

